/* External socket services: supported by sockserv.c */
/* Note that socket numbers are file descriptors, typically small integers */

#define MAX_SERVED_SOCKETS 4

/* Output functions: return number of bytes transmitted, or -1 on error */
extern int usputb(int s, char *buf, int buflen);
extern int usputs(int s, char *buf);
extern int usprintf(int s, char *fmt,...);
extern int tprintf(char *fmt,...);

/* Close a socket */
extern close_s(int s);

/*
   ** Startup a server program
   ** portnum = TCP port to listen to
   ** login   = procedure to be called when a new socket is accepted;
   **           should be declared as:  void login(int s);
   **           where: s is the new socket number
   ** The logout condition is detected by a -1 returned from recvline().
 */
extern int startup(int portnum, void (*login) (int));

/*
   ** Set timeout for recvline call
 */
void socktimeout(int msec);
void nosocktimeout(void);

/*
   ** Set line mode: TRUE - only give me complete lines.  
   **                FALSE- give me any data received, even multiple lines.
   ** The default is FALSE.
 */
void setlinemode(int s, int tf);

/*
   ** Receive a line from a socket
   ** s      = [OUT] the socket data was received on;
   ** buf    = [OUT] character buffer containing socket data;
   **                if linemode = TRUE, buffer is terminated with null character
   ** buflen = [IN]  length of the character buffer; 
   ** returns the number of bytes read, or -1 indicating EOF on the socket.
   **         or -2 indicating timeout (if enabled).
 */
extern int recvline(int *s, char *buf, int buflen);
extern int startcli(char *hostname, int portnum);
extern int startcliaddr(int family, unsigned long int addr, unsigned short int portnum);
extern long resolve(char *hostname);

extern int startup_udp(int portnum);
extern void set_udp_peer(long address, int portnum);
extern void get_udp_peer(long *address, int *portnum);
extern int udp_socket;
extern char sockserv_error[];
