/*
 * hamlog_ecran.h - Funcoes que tratam do aspecto grafico do HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 */

#ifndef HAMLOG_ECRAN_INCLUDE
#define HAMLOG_ECRAN_INCLUDE

#include "includes.h"

/* Dimensoes do programa */
#define JANELA_TAMANHO_X 480
#define JANELA_TAMANHO_Y 300
#define JANELA_BORDO 5
#define JANELA_CONTACTO_TAMANHO_X 500
#define JANELA_CONTACTO_TAMANHO_Y 300
#define JANELA_SOBRE_TAMANHO_X 250
#define JANELA_SOBRE_TAMANHO_Y 150
#define JANELA_LISTA_TAMANHO_X 175
#define JANELA_LISTA_TAMANHO_Y 200
#define JANELA_CALENDARIO_TAMANHO_X 250
#define JANELA_CALENDARIO_TAMANHO_Y 250

/* comprimento maximo do conteudo */
#define MAXIMO_COMPRIMENTO_CONTEUDO 200


#define ENTRADA_NUMEROS_INTEIROS 0
#define ENTRADA_NUMEROS_REAIS 1
#define ENTRADA_DATAS 2
#define ENTRADA_LETRAS 3

/* Numero de colunas que sao realmente mostradas na lista */
#define MOSTRA_NUMERO_COLUNAS		7
/* Numero de campos */
#define NUMERO_COLUNAS 21
#define NUMERO_CAMPO_INDICATIVO 	0
#define NUMERO_CAMPO_NOME		1
#define NUMERO_CAMPO_BANDA		2
#define NUMERO_CAMPO_PAIS		3
#define NUMERO_CAMPO_MODULACAO		4
#define NUMERO_CAMPO_DATA_INICIO	5
#define NUMERO_CAMPO_CIDADE		6
#define NUMERO_CAMPO_SINAL_REMOTO	7
#define NUMERO_CAMPO_AUDIO_REMOTO	8
#define NUMERO_CAMPO_SINAL_LOCAL	9
#define NUMERO_CAMPO_AUDIO_LOCAL	10
#define NUMERO_CAMPO_OBSERVACOES	11
#define	NUMERO_CAMPO_ANT_RX_REMOTA	12
#define NUMERO_CAMPO_ANT_TX_REMOTA	13
#define NUMERO_CAMPO_ANT_RX_LOCAL	14
#define NUMERO_CAMPO_ANT_TX_LOCAL	15
#define NUMERO_CAMPO_POTENCIA_REMOTA	16
#define NUMERO_CAMPO_POTENCIA_LOCAL	17
#define NUMERO_CAMPO_FREQUENCIA_RX	18
#define NUMERO_CAMPO_FREQUENCIA_TX	19
#define NUMERO_CAMPO_DATA_FIM		20

#define COMPRIMENTO_INDICATIVO	     10
#define COMPRIMENTO_NOME	     40
#define COMPRIMENTO_OBSERVACOES	     200
#define COMPRIMENTO_DATA	     30
#define COMPRIMENTO_CIDADE	     30
#define COMPRIMENTO_PAIS	     30
#define COMPRIMENTO_BANDA	     30
#define COMPRIMENTO_MODULACAO	     30
#define COMPRIMENTO_SINAL	     10
#define COMPRIMENTO_AUDIO	     10
#define COMPRIMENTO_ANTENA	     30
#define COMPRIMENTO_POTENCIA	     10
#define COMPRIMENTO_FREQUENCIA	     20

typedef struct arvore
{
   char *nome;
   GtkWidget *arvore;
   GtkSignalFunc funcao;
} ARVORE;

typedef struct temporario 
{ 
   GList *lista ;
   GtkWidget *entrada;
   gint *campo;
} TEMPORARIO;


typedef struct botao_opcao
{
   GtkWidget *botao;
   GtkWidget *label;
   GtkWidget *janela_pai;
   GList *lista_dados;
   gchar *nome;
   gint numero_campo;
   gpointer *campo_contacto;
} BOTAO_OPCAO;

extern void cria_ecran_principal ( GtkWidget **janela_principal );
extern void cria_ecran_tabelas ( GtkWidget *janela_principal , GtkWidget **tabela );
extern void cria_menus ( GtkWidget *tabela , GtkWidget **barra_menu );
extern void cria_janela_separada ( GtkWidget *tabela , GtkWidget **janela_separada );
extern void cria_arvore ( GtkWidget *janela_separada , GtkWidget **arborizacao , GList *lista_arvore );
extern void cria_lista_colunas ( GtkWidget *janela_separada , GtkWidget **lista_colunas );
extern GtkWidget *cria_botao_opcao_contacto ( GtkWidget *janela, GtkWidget *tabela ,
				gint x , gint y , gint comprimento ,
				gint numero_campo ,
			        CONTACTO *contacto , INFORMACAO *info ,
				gint tipo );
extern GtkWidget *cria_entrada_contacto ( GtkWidget *tabela , 
				     gint x , gint y , 
				     gint comprimento_nome ,
				     gint comprimento_entrada,
				     gint numero_campo ,
				     CONTACTO *contacto , gint tipo );
extern void cria_janela_contacto ( GtkWidget **janela_contacto , INFORMACAO *info, CONTACTO *contacto , gboolean novo );
extern void mostra_lista_opcoes ( BOTAO_OPCAO *botao_opcao );
extern void poe_nome_no_botao ( BOTAO_OPCAO *botao , gchar *dado );
extern void mostra_calendario ( BOTAO_OPCAO *botao_opcao );
#endif
