/*
 * 
 * hamlog_file.c - Funcoes de acesso a ficheiro para o programa HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 */


#include "includes.h"

#include "hamlog.h"
#include "hamlog_callback.h"
#include "hamlog_file.h"
#include "hamlog_util.h"
#include "hamlog_ecran.h"

int le_bases_dados ( gchar *nome_ficheiro , GList **conteudo )
{
   FILE *ficheiro;
   gchar linha[COMPRIMENTO_MAXIMO_LINHA];
   gint numero_linha;
   BASES_DADOS *dados;
   *conteudo = NULL;
   if ( nome_ficheiro == NULL ) return(EXIT_FAILURE);
#ifdef HAMLOG_DEBUG	
	g_print ("Lendo ficheiro [%s]\n" , nome_ficheiro );
#endif	

   if ( ( ficheiro = fopen ( nome_ficheiro , "a+" ) ) == NULL )
     {
	perror (nome_ficheiro);
	return (EXIT_FAILURE);
     }
   /* cria lista ligada */
   *conteudo = g_list_alloc ();
   numero_linha = 1;
   rewind(ficheiro);
   while (! feof (ficheiro ))
     {
	if ( fscanf ( ficheiro , " %[^\n]s" , linha ) != 1 ) break;
#ifdef HAMLOG_DEBUG	
	g_print ("Lendo linha contendo [%s]\n" , linha );
#endif	
	/* guarda espaco para a estrutura de dados */
	if ( (dados = g_malloc ( sizeof ( BASES_DADOS ))) == NULL ) break;
	if ( separa_dados ( linha , dados ) == EXIT_SUCCESS )
	  {
	     
	     /* verifica se ja' existe um dado igual */
	     if ( procura_nome_na_lista ( *conteudo , dados->nome ) != NULL )
	  	{
	     		g_print("Ficheiro [%s] %s [%d] %s!\n", nome_ficheiro, TEXTO_LINHA,
		     		numero_linha , TEXTO_REPETIDOS);
	     		g_free ( dados );
	  	}
	     else
		/* acrescenta ao fim da lista ligada */
		g_list_append ( *conteudo , dados );
	  }
	else
	  g_print ("Ficheiro [%s] Linha [%d] contem erros!\n" ,
		    nome_ficheiro, numero_linha );
	  
	numero_linha++;
     }
   fclose (ficheiro);
   return (EXIT_SUCCESS);
}

int le_indicativos ( gchar *nome_ficheiro , GList **indicativos )
{
   FILE *ficheiro;
   gchar linha[COMPRIMENTO_MAXIMO_LINHA];
   CONTACTO *dados;
   gint numero_linha;
   *indicativos = NULL;
   if ( nome_ficheiro == NULL ) return(EXIT_FAILURE);
#ifdef HAMLOG_DEBUG	
	g_print ("Lendo ficheiro [%s]\n" , nome_ficheiro );
#endif	

   if ( ( ficheiro = fopen ( nome_ficheiro , "a+" ) ) == NULL )
     {
	perror (nome_ficheiro);
	return (EXIT_FAILURE);
     }
   /* cria lista ligada */
   *indicativos = g_list_alloc ();
   numero_linha=1;
   rewind(ficheiro);
   while (! feof (ficheiro ))
     {
	if ( fscanf ( ficheiro , " %[^\n]s" , linha ) != 1 ) break;
#ifdef HAMLOG_DEBUG
	g_print ("Lendo linha contendo [%s]\n" , linha );
#endif
	/* guarda espaco para a estrutura de dados do indicativo */
	if ( (dados = cria_estrutura_contacto () ) == NULL ) break;
	if ( separa_dados_indicativo ( linha , dados ) == EXIT_SUCCESS )
	  {
#ifdef HAMLOG_DEBUG
	   	g_print ("Linha OK\n");
#endif
		/* acrescenta ao fim da lista ligada */
		g_list_append ( *indicativos , dados );
	  }
	else
	  {
	  	g_print ("Ficheiro [%s] Linha [%d] contem erros!\n" , 
		    	nome_ficheiro, numero_linha );
	     	liberta_estrutura_contacto( NULL , &dados );
	  }
	
	numero_linha++;
     }
   fclose (ficheiro);
   return (EXIT_SUCCESS);
}


int retira_numero ( gint *numero , gchar **linha_temp )
{
   gchar *temp;
   gchar *endptr;
   if ( (temp = strtok ( NULL , SEPARADOR_BASES_DADOS ))==NULL)
     {
	g_free ( *linha_temp );
	return (EXIT_FAILURE);
     }
#ifdef HAMLOG_DEBUG
	g_print ("Lendo campo contendo [%s]\n" , temp );
#endif
   *numero = strtol ( temp , &endptr , 0 );
   if ( *endptr != '\0' )
     {
	g_free ( *linha_temp );
     	return (EXIT_FAILURE);
     }
#ifdef HAMLOG_DEBUG
	g_print ("que deu o numero [%d]\n" , *numero );
#endif   
   return ( EXIT_SUCCESS);
}

int retira_numero_frequencia ( gfloat *numero , gchar **linha_temp )
{
   gchar *temp;
   gchar *endptr;
   if ( (temp = strtok ( NULL , SEPARADOR_BASES_DADOS ))==NULL)
     {
	g_free ( *linha_temp );
	return (EXIT_FAILURE);
     }
#ifdef HAMLOG_DEBUG
	g_print ("Lendo campo contendo [%s]\n" , temp );
#endif
   *numero = strtod ( temp , &endptr );
   if ( *endptr != '\0' )
     {
	g_free ( *linha_temp );
     	return (EXIT_FAILURE);
     }
#ifdef HAMLOG_DEBUG
	g_print ("que deu o numero [%f]\n" , *numero );
#endif   
   return ( EXIT_SUCCESS);
}


int separa_dados_indicativo ( gchar *linha , CONTACTO *dados )
{
   gchar *temp , *linha_temp;
   linha_temp = g_strdup ( linha );
   /* indicativo */
   if ((temp=strtok(linha_temp,SEPARADOR_BASES_DADOS))==NULL)
     { g_free(linha_temp); return(EXIT_FAILURE); }
   if ( strlen(temp) > COMPRIMENTO_INDICATIVO ) return(EXIT_FAILURE);
   strcpy ( dados->indicativo , temp );
   /* nome */
   if ((temp=strtok(NULL,SEPARADOR_BASES_DADOS))==NULL)
     { g_free(linha_temp); return(EXIT_FAILURE); }
   if ( strlen(temp) > COMPRIMENTO_NOME ) return(EXIT_FAILURE);   
   strcpy(dados->nome , temp );
   /* observacoes */
   if ((temp=strtok(NULL,SEPARADOR_BASES_DADOS))==NULL)
     { g_free(linha_temp); return(EXIT_FAILURE); }
   if ( strlen(temp) > COMPRIMENTO_OBSERVACOES ) return(EXIT_FAILURE);   
   strcpy(dados->observacoes , temp );
   /* cidade:*/
   if ( retira_numero ( & (dados->cidade), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* pais:*/
   if ( retira_numero ( & (dados->pais), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* banda:*/
   if ( retira_numero ( & (dados->banda), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* tipo de modulacao:*/
   if ( retira_numero ( & (dados->tipo_modulacao), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* nivel do sinal local:*/
   if ( retira_numero ( & (dados->nivel_sinal_local), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* nivel do radio local:*/
   if ( retira_numero ( & (dados->nivel_audio_local), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* nivel do sinal remoto:*/
   if ( retira_numero ( & (dados->nivel_sinal_remoto), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* nivel do radio remoto:*/
   if ( retira_numero ( & (dados->nivel_audio_remoto), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* potencia remota */
   if ( retira_numero ( & (dados->potencia_remota), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* potencia local */
   if ( retira_numero ( & (dados->potencia_local), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* antena de emissao remota */
   if ( retira_numero ( & (dados->antena_tx_remota), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* antena de recepcao remota */
   if ( retira_numero ( & (dados->antena_rx_remota), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* antena de emissao local */
   if ( retira_numero ( & (dados->antena_tx_local), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* antena de recepcao local */
   if ( retira_numero ( & (dados->antena_rx_local), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* frequencia de emissao */
   if ( retira_numero_frequencia ( & (dados->frequencia_tx), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* frequencia de recepcao */
   if ( retira_numero_frequencia ( & (dados->frequencia_rx), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* data de inicio de contacto */
   if ( retira_numero ( & (dados->data_inicio), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);
   /* data de fim de contacto */
   if ( retira_numero ( & (dados->data_fim), &linha_temp ) == EXIT_FAILURE )
     return (EXIT_FAILURE);   
   g_free(linha_temp);
   return (EXIT_SUCCESS);
}


int separa_dados ( gchar *linha , BASES_DADOS *dados )
{
   gchar *temp , *linha_temp;
   linha_temp = g_strdup ( linha );
   /* numero */
   if ( ( temp = strtok ( linha_temp , SEPARADOR_BASES_DADOS )) == NULL )
     {
	g_free ( linha_temp );
     	return (EXIT_FAILURE);
     }
   if (( dados->numero = strtol ( temp , NULL , 0 )) == 0 )
     {
	g_free ( linha_temp );
     	return (EXIT_FAILURE);
     }
   /* nome */
   if ( ( temp = strtok ( NULL , SEPARADOR_BASES_DADOS )) == NULL )
     {
	g_free ( linha_temp );
	return (EXIT_FAILURE);
     }
   dados->nome = g_strdup ( temp );
   g_free ( linha_temp );
   return (EXIT_SUCCESS);
}


void mostra_dados ( GList *lista_dados )
{
   GList *corrente;
   BASES_DADOS *dados;
   if ( lista_dados == NULL ) return;
   corrente = lista_dados->next;
   while ( corrente !=NULL )
     {
	if ( ( dados = corrente->data ) == NULL ) break;
	printf ("%d -> %s\n" , dados->numero , dados->nome );
	corrente = corrente->next;
     }
}


void mostra_dados_indicativo ( GList *lista_indicativos )
{
   GList *corrente;
   CONTACTO *indicativo;
   if ( lista_indicativos == NULL ) return;
   corrente = lista_indicativos->next;
   while ( corrente !=NULL )
     {
	if ( ( indicativo = corrente->data ) == NULL ) break;
	printf ("%s -> %s\n" , indicativo->indicativo , indicativo->nome );
	corrente = corrente->next;
     }
}


int grava_indicativos ( gchar *nome_ficheiro , GList *lista_indicativos )
{
   FILE *ficheiro;
   GList *corrente;
   CONTACTO *contacto;
   gchar nome_backup[1024];

   if ( ( nome_ficheiro == NULL ) || ( lista_indicativos ) == NULL )
     return(EXIT_FAILURE);
   strcpy ( nome_backup , nome_ficheiro );
   strcat ( nome_backup , EXTENSAO_DE_BACKUP );
   if ( rename(nome_ficheiro, nome_backup) != 0 )
     {
	perror(nome_backup);
	return(EXIT_FAILURE);
     }
   
   if ( ( ficheiro = fopen ( nome_ficheiro , "w" )) == NULL )
     {
	perror (nome_ficheiro);
	return (EXIT_FAILURE);
     }
   corrente = lista_indicativos->next;
   while ( corrente != NULL )
     {
	if (( contacto = corrente->data ) == NULL )break;
	fprintf ( ficheiro , "%s|%s|%s|%d|%d|%d|%d|%d|%d|%d|%d|%d|%d|%d|%d|%d|%d|%f|%f|%ld|%ld\n",
	contacto->indicativo, contacto->nome , contacto->observacoes ,
	contacto->cidade, contacto->pais , contacto->banda, contacto->tipo_modulacao,
	contacto->nivel_sinal_local, contacto->nivel_audio_local,
	contacto->nivel_sinal_remoto, contacto->nivel_audio_remoto,
	contacto->potencia_remota, contacto->potencia_local,
	contacto->antena_tx_remota, contacto->antena_rx_remota,
	contacto->antena_tx_local, contacto->antena_rx_local,
	contacto->frequencia_tx, contacto->frequencia_rx ,
	contacto->data_inicio , contacto->data_fim );
	corrente = corrente->next;
     }
   fclose (ficheiro);
   return(EXIT_SUCCESS);
}


int grava_dados ( gchar *nome_ficheiro , GList *lista_dados )
{
   FILE *ficheiro;
   GList *corrente;
   BASES_DADOS *dados;
   gchar nome_backup[1024];

   if ( ( nome_ficheiro == NULL ) || ( lista_dados ) == NULL )
     return(EXIT_FAILURE);
   strcpy ( nome_backup , nome_ficheiro );
   strcat ( nome_backup , EXTENSAO_DE_BACKUP );
   if ( rename(nome_ficheiro, nome_backup) != 0 )
     {
	perror(nome_backup);
	return(EXIT_FAILURE);
     }
   
   if ( ( ficheiro = fopen ( nome_ficheiro , "w" )) == NULL )
     {
	perror (nome_ficheiro);
	return (EXIT_FAILURE);
     }
   corrente = lista_dados->next;
   while ( corrente != NULL )
     {
	if (( dados = corrente->data ) == NULL )break;
	fprintf ( ficheiro , "%d|%s\n",
		     dados->numero, dados->nome );
	corrente = corrente->next;
     }
   fclose (ficheiro);
   return(EXIT_SUCCESS);
}
