
/*
 * 
 * hamlog_file.h - Funcoes de acesso a ficheiro para o programa HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 */


#ifndef HAMLOG_FILE_INCLUDE
#define HAMLOG_FILE_INCLUDE

#include "includes.h"

#define SEPARADOR_BASES_DADOS "|"
#define COMPRIMENTO_MAXIMO_LINHA 10*1024

#define EXTENSAO_DE_BACKUP ".bak"

/*
 * estrutura que contem os dados relactivos a um contacto
 */

typedef struct contacto
{
   gchar *indicativo , *nome , *observacoes;
/*   gchar *qth_locator; */
   gint cidade, pais , banda , tipo_modulacao;
/*   gint latitude, longitude; */
   gint nivel_sinal_local, nivel_audio_local;
   gint nivel_sinal_remoto , nivel_audio_remoto;
   gint potencia_remota, potencia_local;
   gint antena_tx_remota , antena_rx_remota;
   gint antena_tx_local , antena_rx_local;
   gfloat frequencia_tx, frequencia_rx;
   time_t data_inicio , data_fim;
} CONTACTO;


/* estrutura que associa um numero a pais, cidade, banda , 
 * tipo de modulacao , tipo de antena , etc 
 */
typedef struct bases_dados
{
   gint numero;
   gchar *nome;
} BASES_DADOS;


extern int le_bases_dados ( gchar *nome_ficheiro , GList **conteudo );
extern int le_indicativos ( gchar *nome_ficheiro , GList **indicativos );
extern int retira_numero ( gint *numero , gchar **linha_temp );
extern int retira_numero_frequencia ( gfloat *numero , gchar **linha_temp );
extern int separa_dados_indicativo ( gchar *linha , CONTACTO *dados );
extern int separa_dados ( gchar *linha , BASES_DADOS *dados );
extern void mostra_dados ( GList *lista_dados );
extern void mostra_dados_indicativo ( GList *lista_indicativos );
extern int grava_indicativos ( gchar *nome_ficheiro , GList *lista_indicativos );
extern int grava_dados ( gchar *nome_ficheiro , GList *lista_dados );

#endif
