/*
 * hamlog_util.c - Funcoes utilitarias para o programa HamLog
 * 
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 * 
 */

#include "includes.h"
#include "hamlog.h"
#include "hamlog_callback.h"
#include "hamlog_file.h"
#include "hamlog_util.h"
#include "hamlog_ecran.h"

void limpa_poe_dados_na_arvore ( GtkWidget *arvore , GList *lista_dados )
{
   GList *corrente;
   BASES_DADOS *dados;
   if ((lista_dados==NULL) || (arvore==NULL)) return;
   corrente = lista_dados->next;
   while ( corrente != NULL )
     {
	if ( ( dados = corrente->data ) == NULL ) break;
	/* verifica se existe um dado igual atras deste,ie, 
	 * se o ja' inserimos */
	if ( procura_nome_na_lista ( lista_dados , dados->nome ) == corrente )
		acrescenta_dado_arvore ( arvore , dados );
	corrente = corrente->next;
     }
}

void limpa_poe_indicativos_na_arvore ( GtkWidget *arvore , GList *lista_indicativos )
{
   GList *corrente;
   CONTACTO *indicativo;
   if ((lista_indicativos==NULL) || (arvore==NULL)) return;
   corrente = lista_indicativos->next;
   while ( corrente != NULL )
     {
	if ( ( indicativo = corrente->data ) == NULL ) break;
	/* verifica se existe um indicativo igual atras deste,ie, 
	 * se o ja' inserimos na arvore */
	if ( procura_indicativo_na_lista ( lista_indicativos , 
					  indicativo->indicativo ) == corrente )
	acrescenta_indicativo_arvore ( arvore , indicativo );
	corrente = corrente->next;
     }
}

void acrescenta_dado_arvore ( GtkWidget *arvore , BASES_DADOS *dados )
{
   GtkWidget *item;
   item = gtk_tree_item_new_with_label( dados->nome );
   gtk_tree_append( GTK_TREE(arvore) , item );
   gtk_widget_show (item);
}

void acrescenta_indicativo_arvore ( GtkWidget *arvore , CONTACTO *dados )
{
   GtkWidget *item;
   item = gtk_tree_item_new_with_label( dados->indicativo );
   gtk_tree_append( GTK_TREE(arvore) , item );
   gtk_widget_show (item);
}

void poe_valores_lista_colunas ( INFORMACAO *info , GtkWidget *lista_colunas , ESCOLHA escolha )
{
   gchar *linha[NUMERO_COLUNAS];
   gint numero_linha;
   GList *corrente, *contactos;
   CONTACTO *contacto;
   if ( info == NULL ) return;
   if (( contactos=info->lista_indicativos) == NULL ) return;
   gtk_clist_freeze( GTK_CLIST(lista_colunas ));
   /* limpa a tabela linha/colunas */
   gtk_clist_clear( GTK_CLIST(lista_colunas ));
   if ( escolha.conteudo == NULL ) 
     {
	gtk_clist_thaw( GTK_CLIST(lista_colunas ));	
	return;
     }
   corrente=contactos->next;
   numero_linha=0;
   while ( corrente != NULL )
     {
	if (( contacto = corrente->data ) == NULL) break;
	converte_contacto_linha_texto ( info , contacto , linha , TRUE );
	/* verifica se o contacto tem o campo com a escolha pretendida */
	if ( g_strcasecmp ( linha[escolha.campo] , escolha.conteudo ) == 0 )
	  {
	     /* acrescenta a' lista */
	     gtk_clist_append( GTK_CLIST(lista_colunas) , linha );
	     /* associa o ponteiro de contacto a esta coluna 
	      * para se poder alterar */
	     gtk_clist_set_row_data (GTK_CLIST(lista_colunas), 
				     numero_linha , contacto );
	     numero_linha++;
	  }
	corrente=corrente->next;
     }
   gtk_clist_thaw( GTK_CLIST(lista_colunas ));
}

GList *procura_indicativo_na_lista ( GList *lista_indicativos , gchar *indicativo )
{
   GList *corrente;
   CONTACTO *procura;
   if ( lista_indicativos == NULL ) return(NULL);
   corrente=lista_indicativos->next;
   while ( corrente != NULL )
     {
	if ( (procura = corrente->data) == NULL ) return(NULL);
	if ( g_strcasecmp ( procura->indicativo ,  indicativo ) == 0)
	  return ( corrente );
	corrente = corrente->next;
     }
   return (NULL);
}

GList *procura_nome_na_lista ( GList *lista_dados , gchar *nome )
{
   GList *corrente;
   BASES_DADOS *procura;
   if ( lista_dados == NULL ) return(NULL);
   corrente=lista_dados->next;
   while ( corrente != NULL )
     {
	if ( (procura = corrente->data) == NULL ) return(NULL);
	if ( g_strcasecmp ( procura->nome , nome ) == 0)
	  return ( corrente );
	corrente = corrente->next;
     }
   return (NULL);
}

void converte_contacto_linha_texto ( INFORMACAO *info , CONTACTO *contacto , gchar *texto[] , gboolean sai )
{
   texto[NUMERO_CAMPO_INDICATIVO]= contacto->indicativo;
   texto[NUMERO_CAMPO_NOME]= contacto->nome;
   texto[NUMERO_CAMPO_OBSERVACOES]= contacto->observacoes;
   texto[NUMERO_CAMPO_BANDA]= converte_numero_em_dado( info->lista_bandas,
						      contacto->banda );
   texto[NUMERO_CAMPO_PAIS]= converte_numero_em_dado( info->lista_paises, 
						contacto->pais );
   texto[NUMERO_CAMPO_MODULACAO]= converte_numero_em_dado( info->lista_modulacoes,
				     contacto->tipo_modulacao);
   texto[NUMERO_CAMPO_DATA_INICIO]= numero_timet_para_letras(contacto->data_inicio);
   texto[NUMERO_CAMPO_CIDADE]= converte_numero_em_dado( info->lista_cidades,
				     contacto->cidade);
   if (sai==TRUE) return;
   texto[NUMERO_CAMPO_DATA_FIM]=numero_timet_para_letras(contacto->data_fim);
   texto[NUMERO_CAMPO_ANT_RX_REMOTA] = converte_numero_em_dado( info->lista_antenas,
				     contacto->antena_rx_remota);
   texto[NUMERO_CAMPO_ANT_TX_REMOTA] = converte_numero_em_dado( info->lista_antenas,
				     contacto->antena_tx_remota);
   texto[NUMERO_CAMPO_ANT_RX_LOCAL] = converte_numero_em_dado( info->lista_antenas,
				     contacto->antena_rx_local);
   texto[NUMERO_CAMPO_ANT_TX_LOCAL] = converte_numero_em_dado( info->lista_antenas,
				     contacto->antena_tx_local);
   
   texto[NUMERO_CAMPO_SINAL_REMOTO]=g_malloc(COMPRIMENTO_SINAL*sizeof(gchar));
   texto[NUMERO_CAMPO_AUDIO_REMOTO]=g_malloc(COMPRIMENTO_SINAL*sizeof(gchar));
   texto[NUMERO_CAMPO_SINAL_LOCAL]=g_malloc(COMPRIMENTO_SINAL*sizeof(gchar));
   texto[NUMERO_CAMPO_AUDIO_LOCAL]=g_malloc(COMPRIMENTO_SINAL*sizeof(gchar));
   sprintf(texto[NUMERO_CAMPO_SINAL_REMOTO],"%d dB", contacto->nivel_sinal_remoto );
   sprintf(texto[NUMERO_CAMPO_AUDIO_REMOTO],"%d", contacto->nivel_audio_remoto );
   sprintf(texto[NUMERO_CAMPO_SINAL_LOCAL],"%d dB", contacto->nivel_sinal_local );
   sprintf(texto[NUMERO_CAMPO_AUDIO_LOCAL],"%d", contacto->nivel_audio_local );
   texto[NUMERO_CAMPO_POTENCIA_REMOTA]=g_malloc(COMPRIMENTO_POTENCIA*sizeof(gchar));
   texto[NUMERO_CAMPO_POTENCIA_LOCAL]=g_malloc(COMPRIMENTO_POTENCIA*sizeof(gchar));   
   sprintf(texto[NUMERO_CAMPO_POTENCIA_LOCAL],"%d W", contacto->potencia_local );
   sprintf(texto[NUMERO_CAMPO_POTENCIA_REMOTA],"%d W", contacto->potencia_remota );
   texto[NUMERO_CAMPO_FREQUENCIA_RX]=g_malloc(COMPRIMENTO_FREQUENCIA*sizeof(gchar));
   texto[NUMERO_CAMPO_FREQUENCIA_TX]=g_malloc(COMPRIMENTO_FREQUENCIA*sizeof(gchar));
   sprintf(texto[NUMERO_CAMPO_FREQUENCIA_RX],"%3.3fMHz", contacto->frequencia_rx );
   sprintf(texto[NUMERO_CAMPO_FREQUENCIA_TX],"%3.3fMHz", contacto->frequencia_tx );
   
}

gchar *converte_numero_em_dado ( GList *lista_dados , gint numero )
{
   GList *corrente;
   BASES_DADOS *dados;
   if ( lista_dados == NULL ) return(DADO_INCORRECTO);
   if ( numero <= 0 ) return(DADO_INCORRECTO);
   corrente=lista_dados->next;
   while ( corrente != NULL )
     {
	if ( ( dados = corrente->data ) == NULL ) break;
	if ( dados->numero == numero ) return(dados->nome);
	corrente=corrente->next;
     }
   return(DADO_INCORRECTO);
}

gchar *converte_numero_campo_em_dado ( INFORMACAO *info , 
				      CONTACTO *contacto,
				      gint numero_campo )
/*
 * Retorna o dado correspondente ao numero que o contacto contem no numero
 * de campo pedido
 */

{
   GList *lista_dados;
   gint *campo;
   /* vai buscar a lista que corresponde a este numero de campo */
   lista_dados = converte_numero_campo_info_em_lista ( info , numero_campo );
   if ( lista_dados == NULL ) return (DADO_INCORRECTO);
   /* vai buscar o ponteiro do contacto que corresponde a este numero de campo */
   campo = (gint*) ponteiro_do_campo_de_contacto ( contacto, numero_campo );
   if ( campo == NULL ) return (DADO_INCORRECTO);
   return ( converte_numero_em_dado ( lista_dados , *campo ));
}

GList *converte_numero_campo_info_em_lista ( INFORMACAO *info ,
					     gint numero_campo )

/* Esta funcao da' o ponteiro da lista de dados que corresponde ao
 * numero de campo dado */
{
   if ( info == NULL ) return(NULL);
   switch (numero_campo)
     {
      case NUMERO_CAMPO_BANDA:
	return(info->lista_bandas);
      case NUMERO_CAMPO_PAIS:
	return(info->lista_paises);
      case NUMERO_CAMPO_MODULACAO:
	return(info->lista_modulacoes);
      case NUMERO_CAMPO_CIDADE:
	return(info->lista_cidades);
      case NUMERO_CAMPO_ANT_RX_REMOTA:
      case NUMERO_CAMPO_ANT_TX_REMOTA:
      case NUMERO_CAMPO_ANT_RX_LOCAL:
      case NUMERO_CAMPO_ANT_TX_LOCAL:
	return(info->lista_antenas);
      default:
	return(NULL);
	break;
     }
   return(NULL);
}


CONTACTO *cria_estrutura_contacto (void)
{
   CONTACTO *contacto;
   contacto = g_malloc0 ( sizeof (CONTACTO));
   if ( contacto == NULL ) return (NULL);
   contacto->indicativo = g_malloc0 ( COMPRIMENTO_INDICATIVO*sizeof(gchar));
   contacto->nome = g_malloc0 ( COMPRIMENTO_NOME*sizeof(gchar));
   contacto->observacoes = g_malloc0 ( COMPRIMENTO_OBSERVACOES*sizeof(gchar));
   strcpy(contacto->observacoes, "-" );
   strcpy(contacto->nome,"-");
   contacto->data_inicio = time(NULL);
   contacto->data_fim    = time(NULL);
   return(contacto);
}

void liberta_estrutura_contacto( GList *lista_indicativos , CONTACTO **contacto )
{
   if ( lista_indicativos != NULL )
   	g_list_remove( lista_indicativos , *contacto );
   g_free ((*contacto)->indicativo);
   g_free ((*contacto)->nome);
   g_free ((*contacto)->observacoes);
   g_free (*contacto);
}

gchar *nomes_botoes ( gint numero_campo )
/*
 * converte o numero de campo para o nome do botao correspondente
 */
{
   switch (numero_campo)
     {
      	       case NUMERO_CAMPO_INDICATIVO:
			return(NOME_CONTACTO_INDICATIVO);
	       case NUMERO_CAMPO_NOME:
	       		return(NOME_CONTACTO_NOME);
	       break;
	       case NUMERO_CAMPO_BANDA:
	       		return(NOME_CONTACTO_BANDA);
	       break;
	       case NUMERO_CAMPO_PAIS:
	       		return(NOME_CONTACTO_PAIS);
	       break;
	       case NUMERO_CAMPO_MODULACAO:
	       		return(NOME_CONTACTO_MODULACAO);	       
	       break;
	       case NUMERO_CAMPO_DATA_INICIO:
	       		return(NOME_CONTACTO_DATA_INICIO);
	       break;
	       case NUMERO_CAMPO_DATA_FIM:
	       		return(NOME_CONTACTO_DATA_FIM);
	       break;
	       case NUMERO_CAMPO_CIDADE:
	       		return(NOME_CONTACTO_CIDADE);	       
	       break;
	       case NUMERO_CAMPO_SINAL_REMOTO:
	       case NUMERO_CAMPO_SINAL_LOCAL:
	       		return(NOME_CONTACTO_SINAL);
	       break;
	       case NUMERO_CAMPO_AUDIO_REMOTO:
	       case NUMERO_CAMPO_AUDIO_LOCAL:
	       		return(NOME_CONTACTO_AUDIO);
	       break;
	       case NUMERO_CAMPO_OBSERVACOES:
	       		return(NOME_CONTACTO_OBSERVACOES);
	       break;
	       case NUMERO_CAMPO_ANT_RX_REMOTA:
	       case NUMERO_CAMPO_ANT_RX_LOCAL:
	       		return(NOME_CONTACTO_ANTENA_RX);       
	       break;
	       case NUMERO_CAMPO_ANT_TX_REMOTA:
	       case NUMERO_CAMPO_ANT_TX_LOCAL:
	       		return(NOME_CONTACTO_ANTENA_TX);
	       break;
	       case NUMERO_CAMPO_POTENCIA_REMOTA:
	       case NUMERO_CAMPO_POTENCIA_LOCAL:
	       		return(NOME_CONTACTO_POTENCIA);
	       break;
	       case NUMERO_CAMPO_FREQUENCIA_RX:
	       case NUMERO_CAMPO_FREQUENCIA_TX:
	       		return(NOME_CONTACTO_FREQUENCIA);
	       break;
      default:
	return ( DADO_INCORRECTO );
     }
   return(NULL);
}
   
gpointer *ponteiro_do_campo_de_contacto ( CONTACTO *contacto, 
					 gint numero_campo )
/*
 * retorna o ponteiro do campo que corresponde ao numero de campo dado
 */
{
   
   switch (numero_campo)
     {
       	       case NUMERO_CAMPO_INDICATIVO:
			return((gpointer)contacto->indicativo);
	       case NUMERO_CAMPO_NOME:
	       		return((gpointer)contacto->nome);
	       case NUMERO_CAMPO_BANDA:
	       		return((gpointer)&(contacto->banda));
	       case NUMERO_CAMPO_PAIS:
	       		return((gpointer)&(contacto->pais));
	       case NUMERO_CAMPO_MODULACAO:
	       		return((gpointer)&(contacto->tipo_modulacao));
	       case NUMERO_CAMPO_DATA_INICIO:
	       		return((gpointer)&(contacto->data_inicio));
	       case NUMERO_CAMPO_DATA_FIM:
	       		return((gpointer)&(contacto->data_fim));
	       case NUMERO_CAMPO_CIDADE:
	       		return((gpointer)&(contacto->cidade));	       
	       case NUMERO_CAMPO_SINAL_REMOTO:
			return((gpointer)&(contacto->nivel_sinal_remoto));
	       case NUMERO_CAMPO_SINAL_LOCAL:
	       		return((gpointer)&(contacto->nivel_sinal_local));
	       case NUMERO_CAMPO_AUDIO_REMOTO:
			return((gpointer)&(contacto->nivel_audio_remoto));
	       case NUMERO_CAMPO_AUDIO_LOCAL:
	       		return((gpointer)&(contacto->nivel_audio_local));
	       case NUMERO_CAMPO_OBSERVACOES:
	       		return((gpointer)contacto->observacoes);
	       case NUMERO_CAMPO_ANT_RX_REMOTA:
			return((gpointer)&(contacto->antena_rx_remota));	
	       case NUMERO_CAMPO_ANT_RX_LOCAL:
			return((gpointer)&(contacto->antena_rx_local));	
	       case NUMERO_CAMPO_ANT_TX_REMOTA:
			return((gpointer)&(contacto->antena_tx_remota));
	       case NUMERO_CAMPO_ANT_TX_LOCAL:
			return((gpointer)&(contacto->antena_tx_local));
	       case NUMERO_CAMPO_POTENCIA_REMOTA:
			return((gpointer)&(contacto->potencia_remota));
	       case NUMERO_CAMPO_POTENCIA_LOCAL:
			return((gpointer)&(contacto->potencia_local));
	       case NUMERO_CAMPO_FREQUENCIA_RX:
	       		return((gpointer)&(contacto->frequencia_rx));
	       case NUMERO_CAMPO_FREQUENCIA_TX:
	       		return((gpointer)&(contacto->frequencia_tx));
      default:
	return ( NULL );
     }
   return(NULL);
}

gint comprimento_maximo_dados ( gint numero_campo )
/*
 * da' o comprimento maximo dos dados para um dado numero de campo
 */
{
   switch (numero_campo)
     {
      	       case NUMERO_CAMPO_INDICATIVO:
			return(COMPRIMENTO_INDICATIVO);
	       case NUMERO_CAMPO_NOME:
	       		return(COMPRIMENTO_NOME);
	       case NUMERO_CAMPO_BANDA:
	       		return(COMPRIMENTO_BANDA);
	       case NUMERO_CAMPO_PAIS:
	       		return(COMPRIMENTO_PAIS);
	       case NUMERO_CAMPO_MODULACAO:
	       		return(COMPRIMENTO_MODULACAO);
	       case NUMERO_CAMPO_DATA_INICIO:
	       case NUMERO_CAMPO_DATA_FIM:
	       		return(COMPRIMENTO_DATA);
	       case NUMERO_CAMPO_CIDADE:
	       		return(COMPRIMENTO_CIDADE);
	       case NUMERO_CAMPO_SINAL_REMOTO:
	       case NUMERO_CAMPO_SINAL_LOCAL:
	       		return(COMPRIMENTO_SINAL);
	       case NUMERO_CAMPO_AUDIO_REMOTO:
	       case NUMERO_CAMPO_AUDIO_LOCAL:
	       		return(COMPRIMENTO_AUDIO);
	       case NUMERO_CAMPO_OBSERVACOES:
	       		return(COMPRIMENTO_OBSERVACOES);
	       case NUMERO_CAMPO_ANT_RX_REMOTA:
	       case NUMERO_CAMPO_ANT_RX_LOCAL:
	       case NUMERO_CAMPO_ANT_TX_REMOTA:
	       case NUMERO_CAMPO_ANT_TX_LOCAL:
	       		return(COMPRIMENTO_ANTENA);
	       case NUMERO_CAMPO_POTENCIA_REMOTA:
	       case NUMERO_CAMPO_POTENCIA_LOCAL:
	       		return(COMPRIMENTO_POTENCIA);
	       case NUMERO_CAMPO_FREQUENCIA_RX:
	       case NUMERO_CAMPO_FREQUENCIA_TX:
	       		return(COMPRIMENTO_FREQUENCIA);
	       break;
      default:
	return (0);
     }
   return(0);
}


gchar *numero_inteiro_para_letras ( gint numero )
{
   static gchar letras[MAXIMO_COMPRIMENTO_CONTEUDO];
   sprintf ( letras , "%d" , numero );
   return (letras);
}

gchar *numero_real_para_letras ( gfloat numero )
{
   static gchar letras[MAXIMO_COMPRIMENTO_CONTEUDO];
   sprintf ( letras , "%3.4f" , numero );
   return (letras);
}

gchar *numero_timet_para_letras ( time_t tempo )
{
   static gchar letras[MAXIMO_COMPRIMENTO_CONTEUDO];
   strftime ( letras, MAXIMO_COMPRIMENTO_CONTEUDO,
	     "%H:%M  %a, %d %b %Y", localtime(&tempo));
   return (letras);
}

gint acrescenta_dado_lista ( GList *lista_dados , gchar *texto_de_entrada )
/*
 * acrescenta um dado a uma lista de dados , vai procurar o maior numero
 * atribuido e atribui ao novo dado o numero seguinte
 */
{
   GList *corrente;
   BASES_DADOS *dados;
   gint maior_numero=0;
   if (( lista_dados == NULL ) || ( texto_de_entrada == NULL )) return(0);
   corrente=lista_dados->next;
   while ( corrente != NULL )
     {
	if ( (dados = corrente->data) == NULL ) return(0);
	/* Verifica se ja' existe:*/
	if ( g_strcasecmp ( dados->nome , texto_de_entrada ) == 0 )
	  return ( dados->numero );
	/* Vai ver qual o maior numero */
	if ( dados->numero > maior_numero ) maior_numero = dados->numero;
	corrente = corrente->next;
     }
   dados = g_malloc0 ( sizeof(BASES_DADOS));
   dados->numero = maior_numero + 1;
   dados->nome = g_strdup(texto_de_entrada);
   g_list_append ( lista_dados , dados );
   return ( dados->numero );
}
