/* calc.h */

#ifndef _calc_h
#define _calc_h

#include "data.h"
#include "function.h"
#include "shortcut.h"

#ifndef NULL
#define NULL (void *)0x00
#endif

#ifndef min
#define min(x,y) ((x) < (y) ? (x) : (y))
#endif

#define ac_push(d) push(s, d)
#define ac_pop(d) pop(s, d)
#define ac_push_p(d) push_p(s, d)
#define ac_pop_p() pop_p(s)

/* Due to strangeness on PDCurses' part... */
#ifdef SYS_DOS
#ifdef KEY_BACKSPACE
#undef KEY_BACKSPACE
#endif
#define KEY_BACKSPACE 8
#endif

struct gflags {
	int error;
	int syntax;
	int quit;
};

struct options {
	int deg;
	int num;
	int fix;
	char *rcfile;
	char *savfile;
	char **toolbar;
};

void init_calc(void);
/* Set up initial data structures */

void end_calc(void);
/* Free any data structures used. */

int exec_string(char *s);
/* Takes a string of commands, parses and executes them. 
 *
 * sets flags.quit if the quit function is encountered 
 * returns -1 if there's a syntax error 
 * returns -2 if there's a calculation error 
 * returns 0 otherwise */

int interpret_char(int c);
/* Takes a character; if the character is a command, executes it, otherwise
 * returns -1 for 'handle yourself'.
 * returns -2 if there's a calculation error
 * sets flags.quit for the quit function 
 * returns 0 otherwise */

char **parse_command(char *command, char *buffer);
/* Seperates the string 'command' at whitespace.  Returns an array of pointers
 * to each token, putting the output into 'buffer' */

token det_type(char *token);
/* Takes a single string, and converts it into a token structure.
 * Returns a token of type TTYP_NONE on error. */

int string_to_float(char *s, long double *v);
/* convert string s to a double, stored in v; return nonzero on error */
int string_to_int(char *s, long long *v);
/* convert string to an int */
int hexstring_to_int(char *s, long long *v);
/* convert hex string to int */

char *strend(char *str);
/* Returns a pointer to the trailing null of str */

char *tok_to_str(token tok);
/* Converts a token structure into a human-readable string */

char *tok_to_savstr(token tok);
token savstr_to_tok(char *s);

extern stack *s;

#include "extern.h"

#endif
