/* data.h */

/* Token, register, etc. data structures */

#ifndef _data_h
#define _data_h

#include <stdint.h>

#include "stack.h"

typedef enum {
	TTYP_DEC = 0x01,
	TTYP_HEX = 0x02,
	TTYP_FLT = 0x04,
	TTYP_FUNC = 0x10,
	TTYP_STR = 0x20,
	TTYP_NUM = 0x0F,
	TTYP_INT = 0x03,
	TTYP_ANY = 0xFF,
	TTYP_NONE = -1
} tok_type;

typedef int64_t ac_int_t;
typedef long double ac_flt_t;

typedef struct {
	tok_type typ; /* Type of token stored (decimal, hex; float; func) */
	union {
		ac_int_t lnum;
		ac_flt_t dnum;
		char *str;
	} dat;
} token;

typedef struct {
	stack stk;
	ac_int_t id;
} stack_node;

typedef struct {
	token tok;
	ac_int_t id;
} reg_node;

void datalist_init( void );
void datalist_free( void );
stack *get_stack( ac_int_t id );
void free_stacklist( void );
token *get_reg( ac_int_t id );
void set_reg( ac_int_t id, token tok );
void del_reg( ac_int_t id );
void free_reglist( void );
void free_tok( token *tok );

extern llist stacks;
extern llist regs;

#endif
