#ifndef _error_h
#define _error_h

#include <stdarg.h>
#include <stdio.h>

#include "type.h"

#define ERR_PANIC 0
#define ERR_FATAL 3
#define ERR_CHECK 6
#define ERR_LOG 10

#ifndef DEBUG_ASSERT_MAXLEVEL
#define DEBUG_ASSERT_MAXLEVEL ERR_LOG
#endif

#ifdef DEBUG_REMOVE_ASSERT

/* This ought to be optimized out, right? */
#define aotf_assertk( el, p, fmt, ...) \
	do { \
		if( el <= DEBUG_ASSERT_MAXLEVEL ) { \
			aotf_assert_fn((el), (p) ? TRUE : FALSE, __FILE__, __LINE__, #p, \
			fmt, ##__VA_ARGS__); \
		} else { \
			(p); \
		} \
	} while(0)

#define aotf_assert( el, p, fmt, ...) \
	do { \
		if( el <= DEBUG_ASSERT_MAXLEVEL ) { \
			aotf_assert_fn((el), (p) ? TRUE : FALSE, __FILE__, __LINE__, #p, \
			fmt, ##__VA_ARGS__); \
		} \
	} while(0)

#else
#define aotf_assertk( p, fmt, ...) \
	aotf_assert_fn(ERR_FATAL, (p) ? TRUE : FALSE, __FILE__, __LINE__, #p, \
	fmt, ##__VA_ARGS__)
#define aotf_assert( p, fmt, ... ) \
	aotf_assert_fn(ERR_FATAL, (p) ? TRUE : FALSE, __FILE__, __LINE__, #p, \
	fmt, ##__VA_ARGS__)
#endif

void aotf_assert_fn( int err_level, int p,
				const char *file, int line, char *cond, char *fmt, ... );

#endif
