/* keys_g.c */

#include <gdk/gdkkeysyms.h>
#include "function.h"

struct keymap keys[] = {
	{ '+', "+", IMMED },
	{ GDK_KP_Add, "+", IMMED },
	{ '-', "-", IMMED },
	{ GDK_KP_Subtract, "-", IMMED },
	{ '*', "*", IMMED },
	{ GDK_KP_Multiply, "*", IMMED },
	{ '/', "/", IMMED },
	{ GDK_KP_Divide, "/", IMMED },
	{ '^', "^", IMMED },
	{ '_', "neg", IMMED },
	{ '!', "inv", IMMED },
	{ GDK_Delete, "drop", IMMED },
	{ GDK_KP_Delete, "drop", IMMED },
	{ GDK_BackSpace, "drop", 0 },
	{ GDK_Insert, "swap", IMMED },
	{ GDK_Page_Up, "rot", IMMED },
	{ GDK_Page_Down, "roll", IMMED },
	{ GDK_KP_Enter, "dup", 0 },
	{ GDK_Return, "dup", 0 },
	{ '@', "sqr", IMMED },
	{ '#', "sqrt", IMMED },
	{ 'S', "sin", 0 },
	{ 'C', "cos", 0 },
	{ 'T', "tan", 0 },
	{ 'Q', "quit", 0 },
	{ 'R', "rad", 0 },
	{ 'D', "deg", 0 },
	{ 'E', "exp", 0 },
	{ '<', "sl", IMMED },
	{ '>', "sr", IMMED },
	{ '&', "and", IMMED },
	{ '|', "or", IMMED },
	{ GDK_F1, "1 sc", IMMED },
	{ GDK_F2, "2 sc", IMMED },
	{ GDK_F3, "3 sc", IMMED },
	{ GDK_F4, "4 sc", IMMED },
	{ GDK_F5, "5 sc", IMMED },
	{ GDK_F6, "6 sc", IMMED },
	{ GDK_F7, "7 sc", IMMED },
	{ GDK_F8, "8 sc", IMMED },
	{ GDK_F9, "9 sc", IMMED },
	{ GDK_F10, "10 sc", IMMED },
	{ GDK_F11, "11 sc", IMMED },
	{ GDK_F12, "12 sc", IMMED },
	{ '?', "help", IMMED },
	{ '\0', 0, 0 } };
