/* queue.c */

#include <stdlib.h>
#include <string.h>
#include "queue.h"

#ifndef NULL
#define NULL 0
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

queue queue_new( int db )
{
	queue q;
	
	q = llist_new(db);
	return q;
}

void queue_free( queue *q )
{
	llist_free(q);
}

void *enqueue( queue *q, void *data )
{
	return llist_append(q, data);
}

void *enqueue_p( queue *q, void *data )
{
	return llist_append_p(q, data);
}

void dequeue( queue *q, void *data )
{
	if(!(q->h)) {
		/* Nothing in queue; set data to all 0s */
		memset(data, 0, q->db);
		return;
	}
	
	memcpy(data, q->h->data, q->db);
	llist_remove(q, q->h);
}

void *dequeue_p( queue *q )
{
	void *data;

	if(!(q->h)) {
		/* Nothing in queue; return NULL */
		return NULL;
	}
	
	data = q->h->data;
	llist_shallow_remove(q, q->h);

	return data;
}
