#define LINUX 1

/*
 * To include you own function, do the following:
 *
 * 1. Add the function name to the help below.
 * 2. Write the function code at the beginning of this file.
 * 3. Look for the case of the first letter of your function name
 *    and add
 *                   SF2("yourname",yourname);
 *    for an unary funcion and
 *                   DF2("yourname",yourname);
 *    for a binary funxtion.
 *    You can use
 *                   CST("constant_name",constant_expression);
 *    to add a new constant.
 *
 */
char*gebrauch= "\
 x y + z * [...] \n\
 \n\
-----> operators: \n\
          + - * / mod % ^ ^2 sqr sqrt abs chs \n\
          pow exp ln (=log) log log10 sqrt lg \n\
          floor ceil min max\n\
          sin cos tan  asin acos atan sinh cosh tanh \n\
          gamma nk gcd lcm ggt kgv\n\
          nop\n\
-----> constants: \n\
           pi e \n\
-----> register operations: \n\
           rclx rcly rclz rclt rcll lastx x<>y \n\
           rclx rcly rclz rcll\n\
           sto0 ... sto999 rcl0 rcl999 \n\
           sto+0 ... sto+999 sto-0 ... sto-999\n\
-----> flow control: \n\
           x<y? x<=y? \n\
           x>y? x>=y? \n\
           x==y? x=y? \n\
           x!=y? x<>y? \n\
           0<=x? 0<x? 0==x? 0>x? 0>=x?\n\
           le lt ge gt eq ne gt0 lt0 ge0 le0\n\
           dnz0 dnz999\n\
           lbl... gto... \n\
           exit0 exit1 exitx\n\
-----> printing operations: \n\
           printx printy printz printt printl prints prompt \n\
-----> system values: \n\
           time day month year hour minute second \n\
-----> timing functions: \n\
           sleep timeout timeout1\n\
-----> conversions: \n\
           cm2in cm2pt pt2cm in2cm\n\
-----> precission: \n\
           fix fix_e fix_f fix_g fix_s\n\
-----> format of science on/off: \n\
           sci nosci\n\
           print_timediff\n\
-----> string\n\
           _a-string-or-pathname system\n\
";

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h> /* isatty() */

#ifndef APOLLO
double cube(double x){ return x*x ;}
#endif

/* Some useful constants */
#define	M_E		2.7182818284590452354	/* e */
#define	M_LOG2E		1.4426950408889634074	/* log2(e) */
#define	M_LOG10E	0.43429448190325182765	/* log10(e) */
#define	M_LN2		0.69314718055994530942	/* loge(2) */
#define	M_LN10		2.30258509299404568402	/* loge(10) */
#define	M_PI		3.14159265358979323846	/* pi */
#define	M_PI_2		1.57079632679489661923	/* pi/2 */
#define	M_PI_4		0.78539816339744830962	/* pi/4 */
#define	M_1_PI		0.31830988618379067154	/* 1/pi */
#define	M_2_PI		0.63661977236758134308	/* 2/pi */
#define	M_2_SQRTPI	1.12837916709551257390	/* 2/sqrt(pi) */
#define	M_SQRT2		1.41421356237309504880	/* sqrt(2) */
#define	M_SQRT1_2	0.70710678118654752440	/* sqrt(1/2) */

#define MYNAME fputs(argv[0],stderr),fputs(": ",stderr)

/******************************** begin of additional functions */

static double nk(n,k)double n,k;{
	double y=1.0;
	k = floor ( k + 0.5 );
	n = floor ( n + 0.5 );
	if( k >= 0.5 ) {
		do {
			y*=n;
			y/=k;
			n -= 1.0 ;
			k -= 1.0 ;
		} while( k >= 0.5 );
	}
	return y;
}
static double fact(n)double n;{
	double r=1.0 ;
	while ( n > 0.5 ) r *= n , n -= 1.0 ;
	return r;
}
#define MAX(x,y) (x>y?x:y)
#define MIN(x,y) (x<y?x:y)
static double mygamma(x) double x;{
#ifdef LINUX
	fprintf(stderr,"Gamma not implemented\n");
	exit(1);
#else
extern int signgam ;
	x = gamma(x) ;
	if ( x >= 88.0 ) fprintf(stderr,"gamma :Data error\n"),exit(1) ;
	x = exp(x);
	if(!signgam) x = -x ;
	return x;
#endif
}
static double gcd(double x,double y){
	int i = x ;
	int j = y ;
	int k = 0 ;
	if ( i == j ) return j ;
	if ( j > i ) k = i , i = j , j = k ;
	while ( ( k = i % j ) > 0 ) i = j , j = k ;
	return j ;
}
static double lcm(double x,double y){
	return rint(x)*rint(y)/gcd(x,y);
}
static double timeout(double x,double y,char*a,int ret){
	time_t clock = time(NULL);
	double e ;
	int i = 1 ;
	if ( a == NULL ) a = "false" ; /* the well known unix tool */
	printf("%d(%d):%s:100.0%%",(int)y,(int)x,a);fflush(stdout);
	while ( (e=time(NULL)-clock) <= y && a && ret==(system(a)==0)){
		int s = MIN((y-e),MAX(0.0,i*x-e));
		printf("\b\b\b\b\b\b%5.1f%%",e/y*100.0);fflush(stdout);
		s && sleep(s);
		i++ ;
	}
	if ( 0.0 < (e-y) && (e-y) <= 1.0 ) e=y ;
	printf("\b\b\b\b\b\b%5.1f%% %.fs\n",e/y*100.0,e);fflush(stdout);
	return e ;
}

/******************************** end of additional functions */

static char *(format_g_tab[30]) = {
	"%20.0g","%20.1g","%20.2g","%20.3g","%20.4g",
	"%20.5g","%20.6g","%20.7g","%20.8g","%20.9g",
	"%20.10g","%20.11g","%20.12g","%20.13g","%20.14g"};
static char *(format_e_tab[30]) = {
	"%20.0e","%20.1e","%20.2e","%20.3e","%20.4e",
	"%20.5e","%20.6e","%20.7e","%20.8e","%20.9e",
	"%20.10e","%20.11e","%20.12e","%20.13e","%20.14e"};
static char *(format_f_tab[30]) = {
	"%20.0f","%20.1f","%20.2f","%20.3f","%20.4f",
	"%20.5f","%20.6f","%20.7f","%20.8f","%20.9f",
	"%20.10f","%20.11f","%20.12f","%20.13f","%20.14f"};
static char *(format_u_tab[30]) = {
	"f","p","n","u","m","","K","M","G","T","?" };

void print(char*f,double v,int sci){
	if ( sci ) {
		char s[10];
		int e=floor(log10(v)/3.0);
		printf(f,v/pow(10,e*3));
		if ( e >= -5 && e <= 4 ) fputs(format_u_tab[e+5],stdout);
		else printf("e%d",e*3);
	} else printf(f,v);
	putchar('\n');
}

#define RAM_N 1000
static double ram[RAM_N];
char s[1024];
char*next(void){
	int i = 1 ;
	int c ;
	while ( (c=getchar()) <= ' ' ) if ( c==EOF ) return NULL ;
	s[0]=c;
	while ( (c=getchar()) > ' ' ) s[i++]=c ;
	s[i++]='\0';
	return s ;
}

main(int argc,char*argv[]){
	int	i=0;
	int	fix;
	char	*format=format_g_tab[12];
	int	format_sci = 0 ;
	time_t	clock=0;
	char	*a = NULL ;
	double	x=0.0,
		y=0.0,
		z=0.0,
		t=0.0,
		l=0.0;
	char	gto[] = "lbl                            " ;
	register char	*p;
	int	readstdin = 0 ;
	register double	(*fkt)(); /* Zeiger auf eine Funktion */

	if ( argc>1 && strcmp(argv[1],"--help")==0 ){
		fprintf(stdout,gebrauch);
		exit(0);
	}
	/*arg_init(argc,argv,NULL,gebrauch);*/

	while ( (readstdin==1&&NULL!=(print(format,x,format_sci),p=next()))||(++i,p=argv[i],i<argc) ) {
		/* p = argv[i] ; */
		switch (*p) {
/*-------------------------------------------------------*/
#define SF2(s,f)  if(!strcmp(p,s)){l=x;x=f(x);continue;}
#define FF2(s,f)  if(!strcmp(p,s)){l=x;f(x);x=y;y=z;z=t;continue;}
#define DF2(s,f)  if(!strcmp(p,s)){l=x;x=f(y,x);y=z;z=t;continue;}
#define OF2(s,f)  if(!strcmp(p,s)){l=x;x=y f x;y=z;z=t;continue;}
#define CST(s,c)  if(!strcmp(p,s)){z=y;y=x;x=c;continue;};
#define IF(s)     if(!strcmp(p,s))
#define IFF       if(p[1]=='\0')

case 'a':
	/*
	 * Functions and constants
	 */
	SF2("asin",asin);
	SF2("acos",acos);
	SF2("atan",atan);
	SF2("abs",fabs);
	OF2("add",+);
	break;

case 'c':
	/*
	 * Functions and constants
	 */
	IF("chs"){   l=x, x= (-x) ; continue ; }
	IF("cm2pt"){ l=x, x*=28.2465 ; continue ; }
	IF("cm2in"){ l=x, x/=2.54899 ; continue ; }
	SF2("ceil",ceil);
	SF2("cos",cos);
	SF2("cosh",cosh);
	IF("cla") { a = NULL ; continue ; }
	break;
case 'd':
	/*
	 * Functions and constants
	 */
	OF2("div",/);
	CST("day",(clock=time(NULL),localtime(&clock)->tm_mday));
	/*
	 * loop until register in memory is zero
	 */
	if ( p[0] == 'd' && p[1] == 'n' && p[2] == 'z' && p[3] != '\0' ) {
		int n = atoi(p+3);
		if ( n < RAM_N ) {
			if ( --ram[n] > 0 ) {
				if ( i < argc-1 ) continue;
			} else {
				if ( ++i < argc ) continue;
			}
		} else {
			fputs("Not enought memory!\n",stderr);
			exit(1);
		}
	}
	break;
case 'e':
	/*
	 * Functions and constants
	 */
	SF2("exp",exp);
	SF2("e^x",exp);
	CST("e",M_E);
	IF("exit0") { exit(0) ; }
	IF("exit1") { exit(1) ; }
	IF("exitx") { exit(floor(x)) ; }
	/*
	 * Conditional operators
	 */
	IF("eq"){if ( x == y ) goto jump0 ; else goto jump1 ;}
	break;

case 'f':
	/*
	 * Functions and constants
	 */
	SF2("floor",floor);
	SF2("fact",fact);
	/*
	 * Select format
	 */
	IF("fix"){l=x;fix=abs((int)x);x=y;y=z;
		if(fix>14)fix=14;format=format_g_tab[fix];
		format_sci=0;
		continue;}
	IF("fix_f"){l=x;fix=abs((int)x);x=y;y=z;
		if(fix>14)fix=14;format=format_f_tab[fix];
		format_sci=0;
		continue;}
	IF("fix_e"){l=x;fix=abs((int)x);x=y;y=z;
		if(fix>14)fix=14;format=format_e_tab[fix];
		format_sci=0;
		continue;}
	IF("fix_g"){l=x;fix=abs((int)x);x=y;y=z;
		if(fix>14)fix=14;format=format_g_tab[fix];
		format_sci=0;
		continue;}
	IF("fix_s"){l=x;fix=abs((int)x);x=y;y=z;
		if(fix>14)fix=14;format=format_f_tab[fix];
		format_sci=1;
		continue;}
	break;

case 'g':
	/*
	 * Functions and constants
	 */
	SF2("gamma",mygamma);
	DF2("gcd",gcd);
	DF2("ggt",gcd);
	/*
	 * Conditional operators
	 */
	IF("ge"){if ( x >= y ) goto jump0 ; else goto jump1 ;}
	IF("gt"){if ( x > y ) goto jump0 ; else goto jump1 ;}
	IF("ge0"){if ( x >= 0.0 ) goto jump0 ; else goto jump1 ;}
	IF("gt0"){if ( x > 0.0 ) goto jump0 ; else goto jump1 ;}
	/*
	 * Jump operators
	 */
	if ( p[0] == 'g' && p[1] == 't' && p[2] == 'o' && p[3] != '\0' ) {
		strcpy(gto+3,p+3);
		i = 1 ;
		while ( i < argc && strcmp(gto,argv[i])!=0 ) i++ ;
		if ( i<argc && !strcmp(gto,argv[i])) continue ;
		MYNAME , fprintf( stderr , " label not found : %s ? \n" , p );
		exit(1);
	}
	break;

case 'h':
	/*
	 * Functions and constants
	 */
	CST("hour",(clock=time(NULL),localtime(&clock)->tm_hour));
	if("help"){puts(gebrauch);continue;}
	break;

case 'i':
	/*
	 * Functions and constants
	 */
	IF("in2cm"){ l=x, x*=2.54899 ; continue ; }
	break;

case 'l':
	/*
	 * Functions and constants
	 */
	SF2("log",log);
	SF2("ln",log);
	DF2("lcm",lcm);
	SF2("log10",log10);
	IF("lastx") { t=z, z=y, y=x, x=l ; continue ; }
	/*
	 * Conditional operators
	 */
	IF("lg"){l=x;x=log(x)/M_LN2;continue;}
	IF("le"){if ( x <= y ) goto jump0 ; else goto jump1 ;}
	IF("lt"){if ( x < y ) goto jump0 ; else goto jump1 ;}
	IF("le0"){if ( x <= 0.0 ) goto jump0 ; else goto jump1 ;}
	IF("lt0"){if ( x < 0.0 ) goto jump0 ; else goto jump1 ;}
	/*
	 * Label
	 */
	if ( p[0] == 'l' && p[1] == 'b' && p[2] == 'l' ) continue ;
	break;

case 'k':
	/*
	 * Functions and constants
	 */
	DF2("kgv",lcm);
	break;

case 'm':
	/*
	 * Functions and constants
	 */
	DF2("mod",fmod);
	DF2("min",MIN);
	DF2("max",MAX);
	OF2("mul",*);
	CST("month",(clock=time(NULL),localtime(&clock)->tm_mon));
	CST("minute",(clock=time(NULL),localtime(&clock)->tm_min));
	break;

case 'n':
	/*
	 * Functions and constants
	 */
	IF("nop") continue ;
	IF("nosci"){ format_sci = 0 ; continue ; }
	DF2("nk",nk);
	IF("nl") { printf("\n") ; continue ; }
	IF("ne") {if ( x != y ) goto jump0 ; else goto jump1 ;}
	break;

case 'p':
	/*
	 * Functions and constants
	 */
	IF("pt2cm"){ l=x, x/=28.2465 ; continue ; }
	DF2("pow",pow);
	CST("pi",M_PI);
	IF("printx") { print(format,x,format_sci) ; continue ; }
	IF("printy") { print(format,y,format_sci) ; continue ; }
	IF("printz") { print(format,z,format_sci) ; continue ; }
	IF("printt") { print(format,t,format_sci) ; continue ; }
	IF("printl") { print(format,l,format_sci) ; continue ; }
	IF("prints") {
		fputs("t:",stdout);print(format,t,format_sci) ;
		fputs("z:",stdout);print(format,z,format_sci) ;
		fputs("y:",stdout);print(format,y,format_sci) ;
		fputs("x:",stdout);print(format,x,format_sci) ;
		continue ;
	}
	IF("print_timediff"){	
		int h ;
		double xx = x ;
		if ( xx < 0.0 ) putchar('-');
		xx=fabs(x);
		h = floor(xx/3600.0);xx-=h*3600;h && printf("%02d:",h);
		h = floor(xx/60.0);xx-=h*60;h&&printf("%0d:",h);
		h=xx;printf("%0d\n",h);
		goto jump0 ;
	}
	IF("prompt") { puts(a?a:(readstdin==1)?next():argv[++i]) ; continue ; }
	break;

case 'r':
	/*
	 * Memory operation RCL...
	 */
	if ( p[0] == 'r' && p[1] == 'c' && p[2] == 'l' && p[4] == '\0' ) {
		double h;
		if ( p[3] == 'l' ) h = l ;
		else if ( p[3] == 'x' ) { h = x ; }
		else if ( p[3] == 'y' ) { h = y ; }
		else if ( p[3] == 'z' ) { h = z ; }
		else if ( p[3] == 't' ) { h = t ; }
		else {
			int n = atoi(p+3);
			if ( n < RAM_N ) {
				h=ram[n];
			} else {
				fputs("Not enought memory!\n",stderr);
				exit(1);
			}
		}
		t=z,z=y,y=x,x=h;continue;
	}
	/* break; */

case 's':
	/*
	 * Functions and constants
	 */
	SF2("sqrt",sqrt)
	SF2("sqr",cube);
	SF2("sin",sin);
	SF2("sinh",sinh);
	OF2("sub",-);
	FF2("sleep",x>0&&sleep);
	IF("sci"){ format_sci = 1 ; continue ; }
	CST("second",(clock=time(NULL),localtime(&clock)->tm_sec));
	CST("system",((a && strlen(a))?system(a):0));
	/*
	 * Memory operation STO...
	 */
	if ( p[0] == 's' && p[1] == 't' && p[2] == 'o' && p[3] != '\0' ) {
		int n = atoi(p+3);
		if ( p[3]=='+' || p[3] == '-' ) {
			if ( p[4] == '\0' ) break ;
			n = atoi(p+4) ;
		}
		if ( n < RAM_N ) {
			if ( p[3]=='+' ) { ram[n]+=x ; continue ; }
			if ( p[3]=='-' ) { ram[n]-=x ; continue ; }
			ram[n]=x; continue;
		} else {
			fputs("Not enought memory!\n",stderr);
			exit(1);
		}
	}
	break;

case 't':
	/*
	 * Functions and constants
	 */
	SF2("tan",tan);
	SF2("tanh",tanh);
	CST("time",time(NULL));
	IF("timeout") {
		l=x, x=timeout(x,y,a,1==0) ;
		if ( readstdin == 1 || i < argc-1 ) continue;
		exit((y-x)<0);
	}
	IF("timeout1") {
		l=x, x=timeout(x,y,a,0==0) ;
		if ( readstdin == 1 || i < argc-1 ) continue;
		exit((y-x)<0);
	}
	break;

case 'x':
	/*
	 * Functions and constants
	 */
	/*
	 * conditional operators
	 */
#define V(v,p) \
if((p)[0]=='y'&&(p)[1]=='?'){if(x v y)goto jump0;goto jump1;}else break;

	if ( p[1] == '<' ) {
		if ( p[2] == '=' ) { V(<=,p+3) ;}
		if ( p[2] == '>' ) {
			if ( p[3] == 'y' && p[4] == '\0' ) {
	/* x<>y */		l=x, x=y, y=l ; continue ;
	/* x<>y? */	} else { V(!=,p+3) ;}
		} 
		else { V(<,p+2) ;}
	} else if ( p[1] == '>' ) {
		if ( p[2] == '=' ) { V(>=,p+3) ;}
		else { V(>,p+2) ;}
	} else if ( p[1] == '=' ) {
		if ( p[2] == '=' ) { V(==,p+3) ;}
		else { V(==,p+2) ;}
	} else if ( p[1] == '!' ) {
		if ( p[2] == '=' ) { V(!=,p+3) ;}
	} else break;
/*
 * entry point for conditional branch
 */
jump0:
	if ( readstdin == 1 || i < argc-1 ) continue;
	exit(0);
jump1:
	if ( readstdin == 1 && NULL!=next() || ++i < argc ) continue;
	exit(1) ;
case 'y':
	/*
	 * Functions and constants
	 */
	CST("year",(clock=time(NULL),localtime(&clock)->tm_year+1900));
	DF2("y^x",pow);
	break;
case '_':
	{
		static char aa[1024];
		if ( readstdin==1 ) strcpy(a=aa,p+1); else a=p+1;
		continue;
	}
	break;
case '%':
	/*
	 * Functions and constants
	 */
	IFF{ l=x; x=y/100.0*x; continue; }
	break;

case '^':
	/*
	 * Functions and constants
	 */
	SF2("^2",cube);
	IFF{ l=x; x=pow(y,x); y=z; z=t ; continue ; }
	break;

case '*':
	IFF{ l=x; x*=y; y=z; z=t ; continue ; }
	break;

case '/':
	IFF{ l=x; x=y/x; y=z; z=t ; continue ; }
	break;

case '+':
	IFF{ l=x; x+=y; y=z; z=t ; continue ;}
	goto zahl;

case '-':
	IFF{ l=x; x=y-x; y=z; z=t ; continue ; }
	IF("--"){ readstdin=1; continue; }

zahl:
case '0':
case '1':
case '2':
case '3':
case '4':
case '5':
case '6':
case '7':
case '8':
case '9':
case '.':
	{	int n ; double h ; sscanf(p,"%lf%n",&h,&n) ;
		if ( n == (strlen(p)-1) ) { switch(p[n]){
			case 'T' : h*= 1e12  ; n++ ; break ;
			case 'G' : h*= 1e9   ; n++ ; break ;
			case 'M' : h*= 1e6   ; n++ ; break ;
			case 'K' : h*= 1e3   ; n++ ; break ;
			case 'k' : h*= 1e3   ; n++ ; break ;
			case 'm' : h*= 1e-3  ; n++ ; break ;
			case 'u' : h*= 1e-6  ; n++ ; break ;
			case 'n' : h*= 1e-9  ; n++ ; break ;
			case 'p' : h*= 1e-12 ; n++ ; break ;
			case 'f' : h*= 1e-15 ; n++ ; break ;
		} }
		if ( n == strlen(p) ) { l=x, t=z, z=y, y=x, x=h ; continue ; }
	}
	if ( !strcmp("0<x?",p) ) {
		if ( 0<x ) {
			if ( i < argc-1 ) continue;
		} else {
			if ( ++i < argc ) continue;
		}
	}
	if ( !strcmp("0<=x?",p) ) {
		if ( 0<=x ) {
			if ( i < argc-1 ) continue;
		} else {
			if ( ++i < argc ) continue;
		}
	}
	if ( !strcmp("0==x?",p) ) {
		if ( 0==x ) {
			if ( i < argc-1 ) continue;
		} else {
			if ( ++i < argc ) continue;
		}
	}
	if ( !strcmp("0>x?",p) ) {
		if ( 0>x ) {
			if ( i < argc-1 ) continue;
		} else {
			if ( ++i < argc ) continue;
		}
	}
	if ( !strcmp("0>=x?",p) ) {
		if ( 0>=x ) {
			if ( i < argc-1 ) continue;
		} else {
			if ( ++i < argc ) continue;
		}
	}
/*-------------------------------------------------------*/
		}
		fprintf(stderr,argv[0]) ;
		fprintf( stderr , " %s ? \n" , p );
		if ( readstdin==0 ) exit(1);
/*-------------------------------------------------------*/
	}
	print(format,x,format_sci);
	return 0;
}

