#include "dots.h"


/***********************************************************/
/* iterate z := c exp(z), where c=(c_r,c_i) is a params */
int
julia_expf( z )
	complex z;
{
	int  first_time = 1, iteration;

	static complex c;
	complex u, v, w, z2, z3;

	if( first_time ) {
		first_time = 0;
		c.real = c_r; c.imag = c_i;
	}

	for( iteration = 0; iteration < newt_iter; iteration++){
		/* z := c exp(z) */

		if( z.real > max_distance ) {
			return( ripples ? iteration : 0 );
		}

		EXP(z,w);
		MUL(c,w,z);
	}
	return( ripples ? iteration : 1 );
}
/***********************************************************/
/* iterate z := z^3 + c, where c=(c_r,c_i) is a params */
int
julia_set_3( z )
	complex z;
{
	int  first_time = 1, iteration;

	double r;
	static complex c;
	complex u, v, w, z2, z3;

	if( first_time ) {
		first_time = 0;
		c.real = c_r; c.imag = c_i;
	}

	for( iteration = 0; iteration < newt_iter; iteration++){
		/* z := (2k^3+1)/(3k^2-1) */

		ABS(z,r);
		if( r > max_distance ) {
			return( ripples ? iteration : 0 );
		}

		MUL(z,z,z2);	/* z2 = z^2 */
		MUL(z,z2,z3);	/* z2 = z^2 */
		ADD(c,z3,z);	/* z = z^2 + c */
	}
	return( ripples ? iteration : 1 );
}
/***********************************************************/
/* iterate z := z^2 + c, where c=(c_r,c_i) is a params */
int
julia_set( z )
	complex z;
{
	int  first_time = 1, iteration;

	double r;
	static complex c;
	complex u, v, w, z2, z3;

	if( first_time ) {
		first_time = 0;
		c.real = c_r; c.imag = c_i;
	}

	for( iteration = 0; iteration < newt_iter; iteration++){
		/* z := (2k^3+1)/(3k^2-1) */

		ABS(z,r);
		if( r > max_distance ) {
			return( ripples ? iteration : 0 );
		}

		MUL(z,z,z2);	/* z2 = z^2 */
		ADD(c,z2,z);	/* z = z^2 + c */
	}
	return( ripples ? iteration : 1 );
}
/***********************************************************/
int
cube_roots( z )
	complex z;
{
	int  iteration;

	complex u, v, w, z2, z3;

	for( iteration = 0; iteration < newt_iter; iteration++){
		/* z := (2k^3+1)/(3k^2-1) */

		MUL(z,z,z2);	/* z2 = z^2 */
		MUL(z,z2,z3);	/* z3 = z^3 */

		if( (fabs( z3.real - 1.0 ) < epsilon )
		&&  ( fabs(z3.imag) < epsilon ) ) { break; }

		/* get the denominator */
		u.real = 3.0 * z2.real;
		u.imag = 3.0 * z2.imag;	/* u = 3 z^2 */
		INV(u,w);		/* w = (3 z^2)^(-1) */

		/* get the numerator */
		v.real = 2.0 * z3.real + 1.0;
		v.imag = 2.0 * z3.imag;		/* v = 2 z^3 + 1 */

		/* divide */
		MUL(w,v,z);


	}
	if( ripples ) return( iteration );

	return( fabs( z.imag ) < epsilon );
}
/***********************************************************/
/* NR for x^3 - x - 1 */
int
poly_root( z )
	complex z;
{
	int  iteration;

	complex w, z2, z3;

	for( iteration = 0; iteration < newt_iter; iteration++){
		/* z := (2z^3+1)/(3z^2-1) */

		MUL(z,z,z2);
		MUL(z,z2,z3);
		SUB(z3,z,w);

		/* get the denominator */
		z2.real = 3.0 * z2.real - 1.0;
		z2.imag = 3.0 * z2.imag;
		INV(z2,z2);

		if( (fabs( w.real - 1.0 ) < epsilon )
		&&  ( fabs(w.imag) < epsilon ) ) { break; }

		/* get the numerator */
		z3.real = 2.0 * z3.real + 1.0;
		z3.imag = 2.0 * z3.imag;

		/* divide */
		MUL(z2,z3,z);

	}
	return( ripples ? iteration : ( fabs(z.imag) < epsilon ) );
}
/***********************************************************/
int
mandel( k )
	complex k;
{
	int  iteration;

	complex w, z;

	z.real =  z.imag = 0.0;

	if(debug)printf("Mandel:\tkr: %g\tki: %g\n",
		k.real, k.imag  );

	for( iteration = 0; iteration < newt_iter; iteration++){
		double   distance = 0.0, real_part, imag_part;

		ADD(z,k,w);
		MUL(w,w,z); /* z = (z+k)^2 */


		ABS(z,distance);

		if(debug)printf("Loop:\tzr: %g\tzi: %g\td: %g\n",
			z.real, z.imag, distance );

		if (distance  >= max_distance) {
			return( ripples ? iteration : 0 );
		}
	}
	return( ripples ? iteration : 1 );

}
/***********************************************************/
int
nothing( k )
	complex k;
{

	return( 1 );

}
/***********************************************************/
