#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "params.h"

/* #define defined_display "fibonacci:0.0" 
This is now a param */


/* Program-wide Variables */

Display		*theDisplay;	/* -- Which display we use */
int		theScreen;	/* -- Which screen on this display */
int		theDepth;	/* -- How many bitplanes is the screen */
unsigned long   theBlackPixel;
unsigned long   theWhitePixel;


/* initX()
 *
 * Sets up the X connection and stores info about the operating environs
 *
 */

initX()
{

/* First, establish connection to the X server. */

	theDisplay = XOpenDisplay( defined_display );

	/* Were we successful? */

	if (theDisplay == NULL)
	{
		fprintf(stderr,"ERROR: Cannot establish connection to %s\n",
			XDisplayName( NULL ) );
		exit(1);
	}


/* Next, Check for default screen and colorplane depth. If == 1, we have
 * a monochrome screen.
 */

	theScreen = DefaultScreen( theDisplay );
	theDepth = DefaultDepth( theDisplay, theScreen );
	theBlackPixel = BlackPixel(theDisplay, theScreen);
	theWhitePixel = WhitePixel(theDisplay, theScreen);

} /* initX */


/* getXInfo()
 *
 * Prints information about the starting terminal.
 */

getXInfo()
{
 	printf("%s version %d of the X Window System, X%d R%d\n",
		ServerVendor(theDisplay),
		VendorRelease(theDisplay),
		ProtocolVersion(theDisplay),
		ProtocolRevision(theDisplay));

	if(theDepth == 1)
	{
		printf("Color plane depth.........%d (monochrome)\n",
			theDepth);

	}
	else
	{
		printf("Color plane depth.........%d\n",
			theDepth);
	}

	printf("Display Width..........%d\n",
			DisplayWidth(theDisplay,theScreen));
	printf("Display Height.........%d\n",
			DisplayHeight(theDisplay,theScreen));
	printf("The display is %s\n", XDisplayName(theDisplay));

} /* getXInfo() */



