/*------------------------------------------------------------------*\

 mca_main.c: draws & updates Mandelbrot Cellular Automaton 
 Copyright (C) 02000 Luke Schubert

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 

 The author may be contacted at luke@dspace.com.au

 file:     mca_main.c
 function: Draws & updates Mandelbrot Cellular Automaton
 Author:   Luke Schubert 13/02/02000
           $Id: mca_main.c,v 1.6 2000/03/28 09:51:27 luke Exp $
	   was test.c (LS, created 01/02/02000); 
	   includes code from helloworld.c 
	   and scribble-simple.c, from the GTK tutorial/examples

\*------------------------------------------------------------------*/

/*------------------------------------------------------------------*\

                              INCLUDES

\*------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "mca_calc.h"

/*------------------------------------------------------------------*\

                              DEFINES

\*------------------------------------------------------------------*/

#define MAX_PALETTE 500

/*------------------------------------------------------------------*\

                              STATICS/GLOBALS

\*------------------------------------------------------------------*/

/* Backing pixmap for drawing area */
static GdkPixmap *pixmap = NULL;
/* static GtkWidget *darea1; */

guint32 loaded_palette[MAX_PALETTE];

/*------------------------------------------------------------------*\

                              FUNCTIONS

\*------------------------------------------------------------------*/

/*------------------------------------------------------------------*\

 function: load_palette
 Author:   Luke Schubert
 Date:     mid-Mar 02000
 
 Attempts to load a Gimp palette ... not currently used.

\*------------------------------------------------------------------*/

void load_palette(char *fname)
{
  FILE *fpPalette;
  int  i, r, g, b;
  int linesize;
  char s[80];
  char *ss;

  fpPalette = fopen(fname, "r");
  fscanf(fpPalette, "%s\n", s);
  /* printf("%s\n", s); */
  fscanf(fpPalette, "%s\n", s);
  /* printf("%s\n", s); */
  r = 0;
  g = 0;
  b = 0;
  while ((i < MAX_PALETTE) && !feof(fpPalette))
    {
      /* fscanf(fpPalette, "\t%d\t%d\t%d %*[a-z] ", &r, &g, &b); */
      /* getline(&s, &linesize, fpPalette); */
      /* printf("%s\n", s);
      r = strtol(s, &ss, 10);
      g = strtol(ss, &ss, 10);
      b = strtol(ss, &ss, 10); */
      /* printf("%d %d %d %d %s ", i, r, g, b, s); */
      loaded_palette[i] = (r * 0x010000) + (g * 0x000100) + (b * 0x000001);
      /* printf("%d %x\n", i, loaded_palette[i]); */
      i++;
    }  
  fclose(fpPalette);
}

/*------------------------------------------------------------------*\

 function: expose_event
 --taken from scribble_simple.c

 Redraw the screen from the backing pixmap 

\*------------------------------------------------------------------*/

static gint
expose_event (GtkWidget *widget, GdkEventExpose *event)
{
  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],  
		   pixmap,
                  event->area.x, event->area.y,
                  event->area.x, event->area.y,
                  event->area.width, event->area.height);
 
  return FALSE;
}

/*------------------------------------------------------------------*\

 function: configure_event
 --taken from scribble_simple.c

 Create a new backing pixmap of the appropriate size 

\*------------------------------------------------------------------*/

static gint
configure_event (GtkWidget *widget, GdkEventConfigure *event)
{
  /* colour_struct mca_colours; */

  if (pixmap)
    gdk_pixmap_unref(pixmap);
 
  pixmap = gdk_pixmap_new(widget->window,
                          widget->allocation.width,
                          widget->allocation.height,
                          -1);
  gdk_draw_rectangle (pixmap,
                      widget->style->white_gc,  
		      TRUE,
                      0, 0,
		      widget->allocation.width,
		      widget->allocation.height); 

  /* mca_colours = mca_calc(0); */

  /* load_palette("/usr/share/gimp/palettes/Volcano"); */

  return TRUE;
}

/*------------------------------------------------------------------*\

 function: mca_step
 Author:   Luke Schubert
 Date:     ? Feb/Mar 02000
 
 Updates colours of Mandelbrot Cellular Automaton in window 

\*------------------------------------------------------------------*/

gint
mca_step (gpointer data)
{
  GtkWidget *widget;         /* object which is written to             */
  GdkGC *mygc;               /* used to hold the current RGB colour    */
  guint32 grading;
  static guint32 time_colour 
    = 0x000000; 
  static int no_gens = 0;    /* number of updates of mca_colours       */
  int i,j;                   /* indices used in "for" loops            */
  colour_struct mca_colours; /* holds the colours returned by mca_calc */
  int this_colour;
  static guint32              
    large_palette[MAX_COLOURS]; /* array of RGB values for colours     */
  guint32 r, g, b,           /* used to create large_palette: original */   
    new_r, new_g, new_b,     /*        "          "         : final    */
    r1, g1, b1;              /*        "          "         : next     */ 
#if RAINBOW
  static guint32 small_palette[12] = {0x000000, /* black */
				      0xff0000, /* red */
				      0xffb000, /* orange */
				      0xffff00, /* yellow */
				      0x80ff00, /* light green */
				      0x00ff00, /* green */
				      0x00ffff, /* cyan */
				      0x00ffb0, /* light green? */
				      0x00b0ff, /* lighter blue? */
				      0x0000ff, /* blue */
				      0xff00ff, /* indigo */
				      0xb000ff  /* violet */
  };
#endif 

#if R_TO_Y
  static guint32 small_palette[MAX_COLOURS];
  small_palette[0] = 0x000000;
  for (i = 1; i < MAX_COLOURS; i++) {
    small_palette[i] = 0xff0000 /* red */
      + ((i-1)*0x00ff00)/MAX_COLOURS; /* to yellow */
  }
#endif

#if B_TO_I
  static guint32 small_palette[MAX_COLOURS];
  small_palette[0] = 0x000000;
  for (i = 1; i < MAX_COLOURS; i++) {
    small_palette[i] = 0x0000ff /* blue */
      + ((i-1)*0xff0000)/MAX_COLOURS; /* to indigo */
  }
#endif

#if G_TO_B
  static guint32 small_palette[MAX_COLOURS];
  small_palette[0] = 0x000000;
  for (i = 1; i < MAX_COLOURS; i++) {
    small_palette[i] = 0x00ff00 /* green */
      - ((i-1)*0x00fe01)/MAX_COLOURS; /* to blue */
  }
#endif

  if (SHADES > 1)
    {
      for (i = 0; i < DIFF_COLOURS; i++)
	{
	  for (j = 0; j < SHADES; j++)
	    {
	      r = small_palette[i] & 0xff0000;
	      new_r = ((r * (j + 1)) / SHADES) & 0xff0000;
	      /* printf("R: %x %x %x\n", r, (r * (j + 1)) / SHADES,
		 new_r); */
	      g = small_palette[i] & 0x00ff00;
	      new_g = ((g * (j + 1)) / SHADES) & 0x00ff00;
	      b = small_palette[i] & 0x0000ff;
	      new_b = ((b * (j + 1)) / SHADES) & 0x0000ff;
	      large_palette[ (i * SHADES) + j] = new_r + new_g + new_b; 
		/* large_palette[i*SHADES + j] = small_palette[i] 
		 * (j+1) / SHADES; */
	      /* printf("%d %d %x\n", i, j, large_palette[i*SHADES + j]); */ 
	    }
	}
    }
  else 
    {
      for (i = 0; i < MAX_COLOURS; i++) {
	large_palette[i] = small_palette[i];
      }
    }

  if (INTERP > 1)
    {
      for (i = 0; i < DIFF_COLOURS - 1; i++)
	{
	  for (j = 1; j <= INTERP; j++)
	    {
	      r = small_palette[i] & 0xff0000;
	      r1 = small_palette[i+1] & 0xff0000;
	      new_r = ((r * j + r1 * (INTERP - j))/INTERP) & 0xff0000;
	      /* printf("R: %x %x %x\n", r, (r * (j + 1)) / SHADES,
		 new_r); */
	      g = small_palette[i] & 0x00ff00;
	      g1 = small_palette[i+1] & 0x00ff00;
	      new_g = ((g * j + g1 * (INTERP - j))/INTERP) & 0x00ff00;
	      b = small_palette[i] & 0x0000ff;
	      b1 = small_palette[i+1] & 0x0000ff;
	      new_b = ((b * j + b1 * (INTERP - j))/INTERP) & 0x0000ff;
	      large_palette[ (i * INTERP) + j] = new_r + new_g + new_b; 
	      printf("%d %d %x\n", i, j, large_palette[i*INTERP + j]);  
	    }
	}
    }	      

  widget = GTK_WIDGET(data);
  mygc = gdk_gc_new(widget->window);
  gdk_gc_copy(mygc, widget->style->black_gc);
  time_colour += 0x00000f;
  gdk_rgb_gc_set_foreground(mygc, time_colour);

  mca_colours = mca_calc(no_gens);
  no_gens++;
  /* g_print("No_gens = %d\n", mca_colours.no_gens); */
  for (i=0;i < CA_WIDTH; i++) {
    for (j=0; j < CA_HEIGHT; j++) {
      this_colour = mca_colours.colour_array[i][j];
      grading = large_palette[this_colour];
      gdk_rgb_gc_set_foreground(mygc, grading);
      gdk_draw_point (pixmap,
		      mygc,
		      i, j);
    }
  } 

  gdk_draw_pixmap(widget->window,
                  widget->style->fg_gc[GTK_WIDGET_STATE (widget)],  
		  pixmap,
		  0,0,
		  0,0,
		  widget->allocation.width, widget->allocation.height); 

  return TRUE;
}

/*------------------------------------------------------------------*\

 function: delete_event
 --taken from helloworld.c

 Delete the window ...

\*------------------------------------------------------------------*/

gint delete_event( GtkWidget *widget,
                   GdkEvent  *event,
		   gpointer   data )
{
    /* If you return FALSE in the "delete_event" signal handler,
     * GTK will emit the "destroy" signal. Returning TRUE means
     * you don't want the window to be destroyed.
     * This is useful for popping up 'are you sure you want to quit?'
     * type dialogs. */

    return(FALSE);
}

/*------------------------------------------------------------------*\

 function: destroy
 --taken from helloworld.c

 Another callback 

\*------------------------------------------------------------------*/

void destroy( GtkWidget *widget,
              gpointer   data )
{
    gtk_main_quit();
}

/*------------------------------------------------------------------*\

 function: main
 author:   Luke Schubert
 date:     01/02/02000

 Redraw the screen from the backing pixmap 

\*------------------------------------------------------------------*/

int main( int   argc,
          char *argv[] )
{
    /* GtkWidget is the storage type for widgets */
    GtkWidget *window;
    GtkWidget *darea1; 
    
    /* This is called in all GTK applications. Arguments are parsed
     * from the command line and are returned to the application. */
    gtk_init(&argc, &argv);

    /* initialise GDK_RGB */
    gdk_rgb_init();

    /* create a new window */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    
    /* what to do when window is deleted */
    gtk_signal_connect (GTK_OBJECT (window), "delete_event",
			GTK_SIGNAL_FUNC (delete_event), NULL);
    
    /* what to do if window is destroyed or deleted successfully */
    gtk_signal_connect (GTK_OBJECT (window), "destroy",
			GTK_SIGNAL_FUNC (destroy), NULL);
    
    /* Sets the border width of the window. */
    gtk_container_set_border_width (GTK_CONTAINER (window), 10);

    gtk_window_set_title (GTK_WINDOW (window), 
			  "Mandelbrot Cellular Automaton");
        
    /* Want to draw! Create a drawing area */
    darea1 = gtk_drawing_area_new ();
    gtk_drawing_area_size (GTK_DRAWING_AREA (darea1), 
			   CA_WIDTH,
			   CA_HEIGHT);

    gtk_container_add (GTK_CONTAINER (window), darea1);

    gtk_widget_show (darea1);

    /* Signals used to handle backing pixmap */
 
    gtk_signal_connect (GTK_OBJECT (darea1), "expose_event",
			(GtkSignalFunc) expose_event, NULL);
    gtk_signal_connect (GTK_OBJECT(darea1),"configure_event",
			(GtkSignalFunc) configure_event, NULL);     

    /* Add a timer callback to update the colours in the mca window */
    gtk_timeout_add (PERIOD, 
		     (GtkFunction) mca_step, 
		     GTK_DRAWING_AREA (darea1));		     

    /* and the window */
    gtk_widget_show (window);
    
    /* wait for an event to occur ... */
    gtk_main ();
    
    return(0);
}



