#include <string.h>
#include <stdio.h>
#include "config.h"
#include "args.h"

struct value {
	int set;
	int vnr;
	char *sval;
};

typedef struct {
	struct value val;
	char *sarg;
	char *larg;
	char *desk;
} arglist;


static arglist args[] = {
	{{0, 0, NULL}, "-v", "--version", "Prints Version"},
	{{0, 0, NULL}, "-h", "--help", "show this usage message."},
	{{0, 0, NULL}, "-f", "--full", "fullscreen mode."},
#ifdef USE_X11
	{{0, 0, NULL}, "-x", "--x11_drv", "Use Xlib."},
#endif
#ifdef USE_VGA
	{{0, 0, NULL}, "-s", "--svga_drv", "Use svgalib."},
#endif
	{{0, 0, NULL}, "-l", "--fps", "Show FPS."},
};

static int arglen = 0;


static int isin(char *c)
{
	int i;
	for (i = 0; i < arglen; i++) {
		if (strcmp(c, args[i].sarg) == 0
		    || strcmp(c, args[i].larg) == 0)
			return i;
	}
	return -1;
}


int init_args(int c, char **v)
{
	int i;
	arglen = sizeof(args) / sizeof(arglist);
	for (i = 1; i < c; i++) {
		int k = isin(v[i]);
		if (k != -1) {
			args[k].val.set = 1;
			if (args[k].val.vnr) {
				i++;
				if (i < c && isin(v[i]) == -1)
					args[k].val.sval = v[i];
				else {
					fprintf(stderr, "error:%s\n",
						args[k].larg);
					return -1;
				}
			}
		}
	}
	return 0;
}

void print_args()
{
	int i;
	for (i = 0; i < arglen; i++)
		printf("%s, %s\t\t%s\n", args[i].sarg, args[i].larg,
		       args[i].desk);
}

int is_arg(char *arg)
{
	int i = isin(arg);
	if (i != -1)
		return args[i].val.set;
	return 0;
}

char *val_arg(char *arg)
{
	int i = isin(arg);
	if (i != -1)
		return args[i].val.sval;
	return NULL;
}
