#include "config.h"
#include <math.h>
#include <float.h>
#include <unistd.h>
#include <stdio.h>
#ifndef OPT
#include <assert.h>
#endif
#include "info.h"
#include "image.h"
#include "engine.h"
#include "mmath.h"
#include "iter.h"
#include "input.h"
#include "set.h"
#include "imtext.h"


#define MAXITER 170
#define MAXRAGE 4
#define MINITER 2

extern struct info info;
extern struct input input;

static double zoom = 100.0;
static double dx = 0;
static double dy = 0;
static int mwiter = MAXITER;
static int miter = MAXITER;
static double mrage = MAXRAGE;
static unsigned long textcolor;

#define S 2e-3
#define Z 2e-3

#define AR_DELTA 50

__inline__ static double ddx(int mx,double f){
	double x=(double) (mx - (int) image_width() / 2) * f;
	return x;
}

__inline__ static double ddy(int my,double f){
	double y=(double) ((int) image_height() / 2 - my) * f;
	return y;
}

static int run_key(double dt)
{
	switch (input.key_n) {
	case 'p':
		mwiter += 10;
		miter = mwiter;
		return 1;
	case 'r':
		mwiter -= 10;
		if (mwiter <= MINITER)
			mwiter = MINITER + 5;
		miter = mwiter;
		return 1;
	case 's':
		zoom *= (1.0 + Z * dt);
		return 1;
	case 'x':
		zoom /= (1.0 + Z * dt);
		if (zoom <= 0.0001)
			zoom = 0.0001;
		return 1;
	default:
		break;
	}
	if(input.arrow){
		double f = (dt * S) / zoom;
		if(input.arrow & UP)
			dy -= AR_DELTA * f;
		if(input.arrow & DOWN)
			dy -= -AR_DELTA * f;
		if(input.arrow & LEFT)
			dx -= -AR_DELTA * f;
		if(input.arrow & RIGHT)
			dx -= AR_DELTA * f;
		return 1;
	}
	if (input.Buttons) {
		if (input.Buttons & B1) {
			zoom *= (1.0 + Z * dt);
		} else if (input.Buttons & B3) {
			zoom /= (1.0 + Z * dt);
			if (zoom <= 0.0001)
				zoom = 0.0001;
		}
		if (input.Buttons & B2) {
			double f = (dt * S) / zoom;
			dx -= ddx(input.mx,f); 
			dy -= ddy(input.my,f);
		}
		return 1;
	} 
	return 2;
}



static int init_iter(void)
{
	if (set_iter() != 0)
		return -1;
	textcolor = rgb_conv(0xff, 0xff, 0xff);
	return 0;
}

int init_eng(void)
{
	create_back();
	if (init_iter() != 0)
		return -1;
	image_to_swap(1);
	iter(dx, dy, zoom, miter, mrage,0, 1);
	return 0;
}

static int print_info(double fps)
{
	int len;
	char buff[255];
	snprintf(buff, 255, "%.2f", fps);
	len = d_string(0, 0, buff, textcolor);
	set_area(0, 0, (TEXT_WIDTH + 2) * 5, TEXT_HEIGHT);
	return len;
}

void run_eng(double dt, double fps)
{

static int re = 0;

	if ((info.events & UPDATE)) {
		info.events &= ~UPDATE;
	}
	if ((info.events & RESIZE)) {
		re = 1;
		image_to_swap(0);
		return;
	} else if (re == 1) {
		re = 0;
		zoom = 100;
		miter = mwiter;
		mrage = MAXRAGE;
		set_set();
		init_eng();
		return;
	}
	if (!image_swap_status()) {
		static int llen = 0;
		if (info.flag & FPS && llen)
			clear_data(0, 0, (TEXT_WIDTH + 2) * llen,
				   TEXT_HEIGHT);

		switch (run_key(dt)) {

		case 1:
			/*image_to_swap(1);*/
			iter(dx, dy, zoom, miter, mrage, fps, 1);
			if (info.flag & FPS)
				llen = print_info(fps);
			break;
		case 2:
			/*image_to_swap(1);*/
			if (info.flag & FPS && llen){
				iter_a(dx, dy, zoom, miter, mrage,
				       0, 0, (TEXT_WIDTH + 2) * llen,
				       TEXT_HEIGHT);
				llen=0;
			}	       
			iter(dx, dy, zoom, miter, mrage,fps, 2);
			break;

		default:
			break;
		}
	}
	if ((info.events & RESIZE)) {
		re = 1;
		image_to_swap(0);
	}
	
}

void end_eng(void)
{
	stop_iter();
}
