//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef ALARM_INCLUDE
#define ALARM_INCLUDE
//
//	The Alarm class defines an alarm timer for an appointment
//
#include <qapp.h>
#include <qwidget.h>
#include <qstring.h>
#include <qfile.h>
#include <qdstream.h>
#include <qdatetm.h>
#include <qmsgbox.h>
#include <qtimer.h>

class Appointment;
class Klook;
class AlarmDialog;

#include "AlarmDialog.h"

class
Alarm : public QObject
{
	private:
	 Q_OBJECT
	 Appointment* appointment;
	 Klook* mainW;
	 QDateTime* alarmTime;
	 int dueOption;
	 bool hasFired;
	 bool repeating;

	 AlarmDialog* alarmBox;
	 
	protected:
	 static const int repeat = 300;

	public:
	 Alarm(Appointment*,Klook* p=0, const char* n=0);
	 Alarm(Appointment*, QDate&,int, int m=0, int d=0, Klook* p=0, const char* n=0);
	 ~Alarm();
	 void setDate(QDate&);
	 void setTime(int, int m=0, int d=0);
	 int getDue();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 void goTimer();
	 QString& getSubject();
	 AlarmDialog* getAlarmBox();
	 bool alreadyFired();
	 bool isRepeating();

	private:
	 void setAlarm(QDate&,QTime&);
	 void beginTimer(int t=repeat);

	protected:
	signals:

	public slots:
	 void killAlarmBox();
	 void reIssueAlarmBox();
	 void timerMessage();

};

#endif
