//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "AlarmDialog.h"

#include "Appointment.h"
#include "Klook.h"
#include "TimeSlots.h"

//
// Default Constructor
//
AlarmDialog::AlarmDialog(Appointment* apt, Klook* parent, const char* name) 
	: QFrame(parent, name)
{
QColor base(255,0,0);

	mainW = parent;

	setCaption(klocale->translate("Kalendar Alarm"));
	resize(200,200);
	setBackgroundColor(base);

	l1 = new QLabel(this);
	l1->setText(klocale->translate("Notification of appointment"));
	l1->setFont(QFont("times",14,QFont::Normal,(int)1));
	l1->setAlignment(AlignHCenter | AlignTop);
	l1->setGeometry(5,10,200,25);
	l1->setBackgroundColor(base);

	l2 = new QLabel(this);
	l2->setText(klocale->translate("Due to start at"));
	l2->setFont(QFont("times",14,QFont::Normal,(int)1));
	l2->setAlignment(AlignHCenter | AlignTop);
	l2->setGeometry(5,80,200,25);
	l2->setBackgroundColor(base);

	Subject = new QLabel(this);
	Subject->setText(apt->getSubject());
	Subject->setFont(QFont("times",14,QFont::Bold,(int)0));
	Subject->setAlignment(AlignHCenter | AlignTop);
	Subject->setGeometry(5,45,200,25);
	Subject->setBackgroundColor(base);

	StartTime = new QLabel(this);
	showStartTime(apt);
	StartTime->setFont(QFont("times",18,QFont::Bold,(int)0));
	StartTime->setAlignment(AlignHCenter | AlignTop);
	StartTime->setGeometry(5,115,200,25);
	StartTime->setBackgroundColor(base);

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->resize(40,30);
	okay->setGeometry(120,160,60,30);
	okay->setDefault(true);
	okay->setBackgroundColor(QColor(255,0,0));

	again = new QPushButton(klocale->translate("Repeat"),this);
	again->resize(40,30);
	again->setGeometry(10,160,60,30);
	again->setBackgroundColor(base);

	connect(okay,SIGNAL(clicked()),this,SLOT(okayPressed()));
	connect(again,SIGNAL(clicked()),this,SLOT(repeatPressed()));

	cycle = 0;
}

//
// Tidy up
//
AlarmDialog::~AlarmDialog()
{
	killTimer(tid);
	delete l1;
	delete l2;
	delete Subject;
	delete StartTime;
	delete okay;
	delete again;
}

//
// exit the dialog
//
void
AlarmDialog::okayPressed()
{
	mainW->setCaption(PACKAGE);
	killTimer(tid);
	emit fired();
}

//
// exit the dialog and re-issue the alarm
//
void
AlarmDialog::repeatPressed()
{
	mainW->setCaption(PACKAGE);
	killTimer(tid);
	emit repeat();
}


//
// return the start time in real time
//
void
AlarmDialog::showStartTime(Appointment* a)
{
TimeSlots ts;

	StartTime->setText(ts.whichTime(a->getStartTime()));
}

//
// Timer event to change the title text of the application
//
void
AlarmDialog::timerEvent(QTimerEvent*)
{
QColor back;

	if(++cycle > 3)
	{
		cycle = 0;
	}

	switch(cycle)
	{
	case 0:
		back=QColor(255,000,000);
		mainW->setCaption(klocale->translate("ALARM - Kalendar"));
		break;
	case 1:
		back=QColor(000,255,000);
		mainW->setCaption(klocale->translate("Kalendar - ALARM"));
		break;
	case 2:
		back=QColor(000,000,255);
		mainW->setCaption(klocale->translate("ALARM - Kalendar"));
		break;
	case 3:
		back=QColor(255,255,000);
		mainW->setCaption(klocale->translate("Kalendar - ALARM"));
		break;
	}

	setBackgroundColor(back);
	l1->setBackgroundColor(back);	
	l2->setBackgroundColor(back);	
	Subject->setBackgroundColor(back);	
	StartTime->setBackgroundColor(back);	
	okay->setBackgroundColor(back);	
}

//
// set a timer to blink the background
//
void
AlarmDialog::blink()
{
	show();
	tid = startTimer(1000);
	QApplication::beep();
}
