//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef ALARMDIALOG_INCLUDE
#define ALARMDIALOG_INCLUDE

#include <qwidget.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qpushbt.h>

#include "../config.h"

class Appointment;
class Klook;

class
AlarmDialog : public QFrame
{
	private:
	 Q_OBJECT
	 QLabel* l1;
	 QLabel* l2;
	 QLabel* Subject;
	 QLabel* StartTime;
	 QPushButton* okay;
	 QPushButton* again;
	 Klook* mainW;

	 int cycle;
	 int tid;

	public:
	 AlarmDialog(Appointment*,Klook* parent=0, const char* name=0);
	 ~AlarmDialog();
	 void blink();

	protected:
	 void timerEvent(QTimerEvent*);
	 void showStartTime(Appointment*);

	protected:
	signals:
	 void fired();
	 void repeat();

	public slots:
	 void okayPressed();
	 void repeatPressed();
};

#endif
