//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef APPOINTMENT_INCLUDE
#define APPOINTMENT_INCLUDE
//
//	The Appointment class contains details of each appointment
//
#include <qwidget.h>
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdstream.h>
#include <qtstream.h>
#include <qdatetm.h>

class Appointment;
class Alarm;
class Klook;
class Repeat;
class Day;
class Export;

class
Appointment
{
	public:
	 enum {none,armed,fired,repeating};
	 enum {public_access,business_access,personnal_access};

	private:
	 QString* subject;	// Subject text
	 QString* text;		// Descriptive text
	 int startTime;		// appointment start
	 int finishTime;	// appointment finish
	 bool valid;		// appointment is currently valid
	 bool alarmed;		// an alarm is associated with this appointment
	 int Sensitivity;	// access restrictions
	 Alarm* alarm;		// the alarm itself
	 Klook* mainW;		// the main application widget
	 Day* day;
	 Repeat* repeat;	// repeating appointment

	public:
	 Appointment(Klook*,Day*,int ind=0);
	 Appointment(Klook*,Day*,QString&,int,int,QString&);
	 ~Appointment();
	 void setSubject(QString&);
	 QString& getSubject();
	 void setText(QString&);
	 QString& getText();
	 void setStartTime(int);
	 int getStartTime();
	 void setFinishTime(int);
	 int getFinishTime();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int,Klook*,bool);
	 void export(QTextStream&,Export&);
	 bool isNew();
	 void makeValid(Klook*);
	 void setAlarm(int,QDate&);
	 void clearAlarm();
	 bool isAlarmed();
	 Alarm& getAlarm();
	 int getAlarmStatus();
	 void setSensitivity(int);
	 int getSensitivity();
	 void setRepeat(Repeat*);
	 Repeat* getRepeat();
	 bool isRepeating();
	 void clearRepeat();
	 Day* getDay();
	 bool findString(QString&);
};

#endif
