//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef CALENDAR_INCLUDE
#define CALENDAR_INCLUDE
//
//	The Calendar class contains a list of days that appointments exist for
//
#include <qwidget.h>
#include <qlist.h>
#include <qdstream.h>
#include <qtstream.h>
#include <qdatetm.h>

class Klook;
class Kdayview;
class Kweekview;
class Kmonthview;
class Kyearplan;
class Appointment;
class Day;
class UserAccess;
class KalDatePicker;
class Repeat;
class Search;
class Export;

#include "Day.h"
#include "Repeat.h"

//
// internal list manipulation class
//
class
DayList : public QList<Day>
{
	public:
	 int compareItems(GCI,GCI);
	 int compareItems(Day*,Day*);
};


class
Calendar
{
	private:
	 QDate currDate;	// the currently selected day
	 DayList days;		// linked list of days
	 QList<Repeat> repeats;	// linked list of repeating events

	public:
	 Calendar();
	 Calendar(QDate&);
	 ~Calendar();
	 QDate &getDate();
	 void setDay(int);
	 void setMonth(int);
	 void setYear(int);
	 void setDate(QDate&);
	 void setDate(int,int,int);
	 int firstDay();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int,Klook*,bool);
	 void export(QTextStream&,Export&);
	 void viewDate(UserAccess*,Kdayview*);
	 void viewDate(UserAccess*,Kweekview*);
	 void viewDate(UserAccess*,Kmonthview*);
	 void viewDate(UserAccess*,Kyearplan*);
	 Appointment* findAppointment(int,Klook*);
	 void removeAppointment(Appointment*);
	 Day* findDay();
	 Day* findDay(QDate&);
	 void cleanCalendar();
	 void remove();
	 Day* addDay(QDate&);
	 Day* addDay(QString&);
	 void markCalendar(KalDatePicker*,int m=0, int y=0);
	 DayEvent* findEvent(int);
	 void removeEvent(DayEvent*);
	 void addRepeat(Repeat*);
	 void removeRepeat(Repeat*);
	 bool checkForConflict(int,int,QDate&);
	 Day* searchForString(Search*);
};

#endif
