//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "DateDuration.h"

DateDuration::DateDuration(int size, QWidget *parent, char *name)
	: QFrame(parent,name,false)
{
	resize(120,40);
	
	setFrameStyle(Box|Raised);

	FinishDate = new QLabel(this);
	FinishDate->setGeometry(0,0,120,30);
	
	realDuration = 0;

	duration = new QSlider(this);
	duration->setValue(realDuration);
	duration->setRange(0,size);
	duration->setSteps(1,1);
	duration->setOrientation(QSlider::Horizontal);
	duration->setGeometry(0,30,120,10);
	duration->setTickmarks(QSlider::NoMarks);

	connect(duration,SIGNAL(valueChanged(int)),SLOT(changeDuration(int)));
}

DateDuration::~DateDuration()
{
	delete FinishDate;
	delete duration;
}

int
DateDuration::getDuration()
{
	return realDuration;
}

void
DateDuration::setDuration(int d, bool slide)
{
	realDuration = d;
	if(slide)
	{
		duration->setValue(realDuration);
	}
//	QDate cdat = currDate.addDays(realDuration);
	currDate = baseDate.addDays(d);
//	FinishDate->setText(cdat.toString());
	FinishDate->setText(currDate.toString());
}

void
DateDuration::changeDuration(int d)
{
	setDuration(d,false);
	emit durationChanged(realDuration);
}

void
DateDuration::setStartDate(QDate& d)
{
	currDate = baseDate = d;
}

void
DateDuration::setCurrentDate(int d)
{
	currDate = baseDate.addDays(d);
	setDuration(realDuration,true);
}

void
DateDuration::setEnabled(bool state)
{
	duration->setEnabled(state);
}

QDate&
DateDuration::getCurrentDate()
{
	return currDate;
}

