//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef DAY_INCLUDE
#define DAY_INCLUDE
//
//	The Day class contains a list of Appointments for a given day
//
#include <qwidget.h>
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdatetm.h>
#include <qdstream.h>
#include <qtstream.h>

class Klook;
class Kdayview;
class Kweekview;
class Kmonthview;
class Kyearplan;
class Appointment;
class UserAccess;
class DayEvent;
class Calendar;
class Search;
class Export;

#include "Appointment.h"
#include "DayEvent.h"

//
// internal list manipulation class
//
// I need this class to allow me sort appointments according to their start
// times. QList::inSort() calls compareItems() automatically so I must define
// the behaviour of the sort.
//
class
AppList : public QList<Appointment>
{
	public:
	 int compareItems(GCI,GCI);
	 int compareItems(Appointment*,Appointment*);
};


//
// The main Day class
//

class
Day
{
	private:
	 QDate day;			// the date to which this day applies
	 QString* dayNote;		// notes for 'today'.
	 AppList list;			// appointment list
	 QList<DayEvent> events;	// day event list
	 Calendar* cal;

	public:
	 Day(Calendar*);
	 Day(Calendar*,QDate&);
	 Day(Calendar*,QDate&,QString&);
	 ~Day();
	 bool remove(bool tidy=false);
	 int getDay();
	 int getMonth();
	 int getYear();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int,Klook*,bool);
	 void export(QTextStream&,Export&);
	 void listDay(Kdayview*,UserAccess*);
	 void listDay(Kweekview*,UserAccess*,int);
	 void listDay(Kmonthview*,UserAccess*,int);
	 void listDay(Kyearplan*,UserAccess*,int,int);
	 QDate& getDate();
	 Appointment* findAppointment(int,Klook*);
	 Appointment* createAppointment(Klook*,int ind=0);
	 void removeAppointment(Appointment*);
	 void addAppointment(Appointment*);
	 bool checkForConflict(int,int,Appointment*);
	 void setDayNote(QString&);
	 QString& getDayNote();
	 int countAppointments();
	 int countEvents();
	 int countNonPublic();
	 DayEvent* findEvent(int);
	 DayEvent* createEvent();
	 void removeEvent(DayEvent*);
	 void addEvent(DayEvent*);
	 bool findHoliday();
	 Calendar* getCalendar();
	 bool findString(QString&);
	 bool searchForString(Search*);
};

#endif
