//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef DAYEVENT_INCLUDE
#define DAYEVENT_INCLUDE
//
//	The Event class contains details of each Event item
//
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qdstream.h>
#include <qtstream.h>
#include <qdatetm.h>

class Repeat;
class Day;
class Export;

class
DayEvent
{
	private:
	 QString* subject;	// Subject text
	 int type;		// type of event (holiday, etc)
	 bool valid;
	 Repeat* repeat;
	 Day* day;
	 bool publicEvent;	// common to all calendars

	public:
	 enum {normal_event,holiday_event,study_event};

	public:
	 DayEvent(Day*);
	 DayEvent(Day*,QString&,int t=0);
	 ~DayEvent();
	 void setSubject(QString&);
	 QString& getSubject();
	 void setType(int);
	 int getType();
	 void save(QDataStream&,bool);
	 void load(QDataStream&,int);
	 void export(QTextStream&,Export&);
	 bool isNew();
	 void makeValid();
	 void setRepeat(Repeat*);
	 Repeat* getRepeat();
	 bool isRepeating();
	 void clearRepeat();
	 Day* getDay();
	 bool isHoliday();
	 bool isStudy();
	 bool findString(QString&);
	 void makePublic();
	 bool isPublic();
};

#endif
