//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDITAPPOINTMENT_INCLUDE
#define EDITAPPOINTMENT_INCLUDE
//
//	The EditAppointment class is used to Edit an Appointment details
//
#include <qpushbt.h>
#include <qchkbox.h>
#include <qmsgbox.h>

#include "../config.h"

class ViewAppointment;
class Appointment;
class Calendar;
class UserAccess;

#include "ViewAppointment.h"

class
EditAppointment : public ViewAppointment
{
	private:
	 Q_OBJECT
	 QCheckBox* AllDayEvent;
	 QCheckBox* Alarm;
	 QComboBox* alarmDue;
	 QPushButton* cancel;
	 bool alarmed;	 

	 UserAccess* access;

	public:
	 EditAppointment(Appointment*,Calendar*,UserAccess*,QWidget* parent=0,const char* name=0);
	 ~EditAppointment();

	private:
	 void populateAlarm();

	protected:
	 void enable();

	protected:
	signals:
	 void saveAppointment(Appointment*);
	 void abortAppointment(Appointment*);

	public slots:
	 void save();
	 void quit();	
	 void changeFinish(int);
	 void setAllDay(bool);
	 void setAlarm(bool);
	 void makeRepeat();
	 void saveRep(Repeat*);
	 void abortRep(Repeat*);
	 void killRep(Repeat*);
};

#endif

