//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "EditEvent.h"

#include <kapp.h>
#include <klocale.h>

#include "DayEvent.h"
#include "EditRepeat.h"
#include "Repeat.h"
#include "Calendar.h"

//
// create a day event
//
EditEvent::EditEvent(DayEvent* t, Calendar* c ,QWidget* parent, const char* name)
	: QDialog(parent,name)
{
	event = t;
	cal = c;

	l1 = new QLabel(this);
	l1->setGeometry( 0, 0, 70, 20 );
	l1->setText(klocale->translate("Subject :"));
	l1->setAlignment( 290 );

	Subject = new QLineEdit(this);
	Subject->setGeometry( 80, 0, 240, 22 );
	Subject->setText( event->getSubject() );
	Subject->setMaxLength( 32767 );
	Subject->setEchoMode( QLineEdit::Normal );
	Subject->setFrame(true);

	Type = new QComboBox(false,this);
	Type->setGeometry(80,30,140,30);
	Type->setSizeLimit(3);
	Type->insertItem(klocale->translate("General"));
	Type->insertItem(klocale->translate("Holiday"));
	Type->insertItem(klocale->translate("Study"));
	Type->setCurrentItem(event->getType());

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->resize(40,30);
	okay->setGeometry(240,240,60,30);
	okay->setDefault(true);

	repeat = new QPushButton(klocale->translate("Repeat"),this);
	repeat->resize(40,30);
	repeat->setGeometry(170,240,60,30);
	repeat->setDefault(true);

	cancel = new QPushButton(klocale->translate("Quit"),this);
	cancel->resize(40,30);
	cancel->setGeometry(100,240,60,30);
	cancel->setDefault(true);

	resize(300,300);

	connect(okay,SIGNAL(clicked()),SLOT(save()));
	connect(cancel,SIGNAL(clicked()),SLOT(quit()));
	connect(repeat,SIGNAL(clicked()),SLOT(makeRepeat()));

	editRep = (EditRepeat*)0;

	Subject->setFocus();
}

//
// tidy up
//
EditEvent::~EditEvent()
{
	delete l1;
	delete Subject;
	delete Type;
	delete okay;
	delete repeat;
	delete cancel;
	if(editRep != (EditRepeat*)0)
	{
		delete editRep;
	}
}

//
// signal emitted when the okay button is presed
//
void
EditEvent::save()
{
	QString sub = Subject->text();
	int t = Type->currentItem();
	if(sub.isEmpty())
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("No subject entered"));
		return;
	}
	event->setSubject(sub);
	event->setType(t);
	emit saveEvent(event);
}

//
// signal emitted when the quit button is presed
//
void
EditEvent::quit()
{
	emit abortEvent(event);
}

//
// Edit a repeating event
//
void
EditEvent::makeRepeat()
{
Repeat* r;
bool newr;

	if(event->isRepeating())
	{
		r = event->getRepeat();
		newr = false;
	}
	else
	{
		r = new Repeat(event->getDay(),event);
		newr = true;
	}

	editRep = new EditRepeat(r,newr,this);
	editRep->setGeometry(0,0,width(),height());
	editRep->resize(width(),height());
	editRep->show();
	connect(editRep,SIGNAL(saveRepeat(Repeat*)),SLOT(saveRep(Repeat*)));
	connect(editRep,SIGNAL(abortRepeat(Repeat*)),SLOT(abortRep(Repeat*)));
	connect(editRep,SIGNAL(killRepeat(Repeat*)),SLOT(killRep(Repeat*)));
}

void
EditEvent::saveRep(Repeat* r)
{
	if(!event->isRepeating())
	{
		cal->addRepeat(r);
	}
	event->setRepeat(r);
	delete editRep;
	editRep = (EditRepeat*)0;
}

void
EditEvent::abortRep(Repeat* r)
{
	if(!event->isRepeating())
	{
		delete r;
	}
	delete editRep;
	editRep = (EditRepeat*)0;
}

void
EditEvent::killRep(Repeat*)
{
	if(event->isRepeating())
	{
		event->clearRepeat();
	}
	delete editRep;
	editRep = (EditRepeat*)0;
}


