//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDITEVENT_INCLUDE
#define EDITEVENT_INCLUDE
//
//	The EditEvent class is used to Edit a event details
//
#include <qwidget.h>
#include <qdialog.h>
#include <qcombo.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlabel.h>
#include <qmsgbox.h>

class DayEvent;
class Repeat;
class EditRepeat;
class Calendar;

class
EditEvent : public QDialog
{
	private:
	 Q_OBJECT

	protected:
	 QLineEdit* Subject;
	 QComboBox* Type;
	 QPushButton* okay;
	 QPushButton* repeat;
	 QPushButton* cancel;
	 QLabel* l1;

	 DayEvent* event;
	 Calendar* cal;

	 EditRepeat* editRep;

	public:
	 EditEvent(DayEvent*,Calendar*,QWidget* parent=0,const char* name=0);
	 ~EditEvent();

	protected:
	signals:
	 void saveEvent(DayEvent*);
	 void abortEvent(DayEvent*);

	public slots:
	 void save();
	 void quit();
	 void makeRepeat();
	 void saveRep(Repeat*);
	 void abortRep(Repeat*);
	 void killRep(Repeat*);
};

#endif
