//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "EditRepeat.h"

#include "DateDuration.h"
#include "ToDo.h"

#include <kapp.h>
#include <klocale.h>

//
// create a new repeating item
//
EditRepeat::EditRepeat(Repeat* r, bool newr, QWidget* parent, const char* name)
	: QDialog(parent,name)
{
	repeat = r;

	l1 = new QLabel(this);
	l1->setGeometry(0,5,70,20);
	l1->setText(klocale->translate("Interval :"));
	l1->setAlignment(290);

	l2 = new QLabel(this);
	l2->setGeometry(0,35,70,20);
	l2->setText(klocale->translate("Until :"));
	l2->setAlignment(290);

	Interval = new QComboBox(false,this);
	Interval->setGeometry( 80, 0, 140, 30 );
	Interval->setSizeLimit(3);
	Interval->insertItem(klocale->translate("Annual"));
	Interval->insertItem(klocale->translate("Month by Day"));
	Interval->insertItem(klocale->translate("Month by Date"));
	Interval->insertItem(klocale->translate("Weekly"));
	Interval->insertItem(klocale->translate("Fortnightly"));
	Interval->setCurrentItem(r->getInterval());

	lastYear = new QComboBox(false,this);
	lastYear->setGeometry( 80, 30, 80, 30 );
	lastYear->setSizeLimit(6);
	lastYear->insertItem(klocale->translate("Forever"));
	lastYear->insertItem("2000");
	lastYear->insertItem("2001");
	lastYear->insertItem("2002");
	lastYear->insertItem("2003");
	lastYear->insertItem("2004");
	lastYear->insertItem("2005");
	lastYear->insertItem("2006");
	lastYear->insertItem("2007");
	lastYear->insertItem("2008");
	lastYear->insertItem("2009");
	lastYear->insertItem("2010");
	lastYear->insertItem("2011");
	lastYear->insertItem("2012");
	lastYear->insertItem("2013");
	lastYear->insertItem("2014");
	lastYear->insertItem("2015");
	int l = r->getYear();
	if(l != 0)
	{
		l -= 1999;
	}
	lastYear->setCurrentItem(l);

	lastMonth = new QComboBox(false,this);
	lastMonth->setGeometry( 170, 30, 100, 30 );
	lastMonth->setSizeLimit(6);
	lastMonth->insertItem(klocale->translate("January"));
	lastMonth->insertItem(klocale->translate("February"));
	lastMonth->insertItem(klocale->translate("March"));
	lastMonth->insertItem(klocale->translate("April"));
	lastMonth->insertItem(klocale->translate("May"));
	lastMonth->insertItem(klocale->translate("June"));
	lastMonth->insertItem(klocale->translate("July"));
	lastMonth->insertItem(klocale->translate("August"));
	lastMonth->insertItem(klocale->translate("September"));
	lastMonth->insertItem(klocale->translate("October"));
	lastMonth->insertItem(klocale->translate("November"));
	lastMonth->insertItem(klocale->translate("December"));
	lastMonth->setCurrentItem(r->getMonth() - 1);

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->resize(40,30);
	okay->setGeometry(240,240,60,30);

	stop = new QPushButton(klocale->translate("Stop"),this);
	stop->resize(40,30);
	stop->setGeometry(170,240,60,30);

	cancel = new QPushButton(klocale->translate("Quit"),this);
	cancel->resize(40,30);
	cancel->setGeometry(100,240,60,30);

	connect(okay,SIGNAL(clicked()),SLOT(save()));
	connect(cancel,SIGNAL(clicked()),SLOT(quit()));
	connect(stop,SIGNAL(clicked()),SLOT(abort()));
	connect(lastYear,SIGNAL(highlighted(int)),SLOT(checkForever(int)));

	enable();
	if(newr)
	{
		stop->setEnabled(false);
	}
}

//
// tidy up
//
EditRepeat::~EditRepeat()
{
	delete l1;
	delete l2;
	delete Interval;
	delete lastMonth;
	delete lastYear;
	delete okay;
	delete stop;
	delete cancel;
}

//
// process the user pressing the okay button
// emit a signal to tell the world we wish to save this data
//
void
EditRepeat::save()
{
	int i = Interval->currentItem();
	int m = lastMonth->currentItem();
	int y = lastYear->currentItem();

	repeat->setInterval(i);

	// not forever, then establish end month and year
	if(y == 0)
	{
		repeat->clearEndDate();
	}
	else
	{
		repeat->setEndDate(1999 + y,m + 1);
	}
	emit saveRepeat(repeat);
}

//
// signal emitted when the user presses the cancel button
//
void
EditRepeat::quit()
{
	emit abortRepeat(repeat);
}

void
EditRepeat::abort()
{
	emit killRepeat(repeat);
}

//
// enable widgets (these were disabled by our parent)
//
void
EditRepeat::enable()
{
	Interval->setEnabled(true);
	checkForever(lastYear->currentItem());
	lastYear->setEnabled(true);
	cancel->show();
}

//
// disable widgets (for view only mode)
//
void
EditRepeat::disable()
{
	Interval->setEnabled(false);
	lastMonth->setEnabled(false);
	lastYear->setEnabled(false);
	cancel->hide();
}


void
EditRepeat::checkForever(int i)
{
	if(i == 0)
	{
		lastMonth->setEnabled(false);
		lastMonth->hide();
	}
	else
	{
		lastMonth->setEnabled(true);
		lastMonth->show();
	}
}
