//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDITREPEAT_INCLUDE
#define EDITREPEAT_INCLUDE
//
//	The EditRepeat class is used to create a repeating item
//
#include <qdialog.h>
#include <qpushbt.h>
#include <qcombo.h>
#include <qlabel.h>

#include "../config.h"

class Repeat;

#include "Repeat.h"

class
EditRepeat : public QDialog
{
	private:
	 Q_OBJECT
	 QLabel* l1;
	 QLabel* l2;
	 QComboBox* Interval;
	 QComboBox* lastMonth;
	 QComboBox* lastYear;
	 QPushButton* okay;
	 QPushButton* stop;
	 QPushButton* cancel;

	 Repeat* repeat;

	public:
	 EditRepeat(Repeat*,bool nr=false,QWidget* parent=0,const char* name=0);
	 ~EditRepeat();

	protected:
	 void enable();

	public:
	 void disable();

	protected:
	signals:
	 void saveRepeat(Repeat*);
	 void abortRepeat(Repeat*);
	 void killRepeat(Repeat*);

	public slots:
	 void save();
	 void quit();	
	 void abort();
	 void checkForever(int);
};

#endif
