//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "EditTask.h"

#include "DateDuration.h"
#include "ToDo.h"

#include <kapp.h>
#include <klocale.h>

//
// create a new task editing widget
//
EditTask::EditTask(ToDo* a, QWidget* parent, const char* name)
	: ViewTask(a,parent,name)
{
	cancel = new QPushButton(klocale->translate("Quit"),this);
	cancel->resize(40,30);
	cancel->setGeometry(170,240,60,30);

	connect(okay,SIGNAL(clicked()),SLOT(save()));
	connect(cancel,SIGNAL(clicked()),SLOT(quit()));

	connect(StartDate,SIGNAL(durationChanged(int)),EndDate,SLOT(setCurrentDate(int)));

	enable();

	Subject->setFocus();
}

//
// tidy up
//
EditTask::~EditTask()
{
	delete cancel;
}

//
// process the user pressing the okay button
// emit a signal to tell the world we wish to save this data
//
void
EditTask::save()
{
	QString txt = TaskText->text();
	QString sub = Subject->text();
	int pri = Priority->currentItem();
	int sense = Sensitivity->currentItem();
//	QDate date = QDate::currentDate().addDays(StartDate->getDuration());
	QDate date = StartDate->getCurrentDate();

	if(sub.isEmpty())
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("No subject entered"));
		return;
	}

	todo->setSubject(sub);
	todo->setText(txt);
	todo->setPriority(pri);
	todo->setStartDate(date);
	todo->setDuration(EndDate->getDuration());
	todo->setSensitivity(sense);
	todo->makeValid();
	emit saveTask();
}

//
// signal emitted when the user presses the cancel button
//
void
EditTask::quit()
{
	emit abortTask(todo);
}

//
// enable widgets (these were disabled by our parent)
//
void
EditTask::enable()
{
	Subject->setReadOnly(false);
	TaskText->setReadOnly(false);
	Priority->setEnabled(true);
	StartDate->setEnabled(true);
	EndDate->setEnabled(true);
	Sensitivity->setEnabled(true);
}


