//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDITTASK_INCLUDE
#define EDITTASK_INCLUDE
//
//	The EditTask class is used to Edit a Task details
//
#include <qpushbt.h>

#include "../config.h"

class ViewTask;
class ToDo;

#include "ViewTask.h"

class
EditTask : public ViewTask
{
	private:
	 Q_OBJECT
	 QPushButton* cancel;

	public:
	 EditTask(ToDo*,QWidget* parent=0,const char* name=0);
	 ~EditTask();

	protected:
	 void enable();

	protected:
	signals:
	 void saveTask();
	 void abortTask(ToDo*);

	public slots:
	 void save();
	 void quit();	
};

#endif
