//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "EditUsers.h"

#include "UserList.h"
#include "UserAccess.h"

#include <kapp.h>
#include <klocale.h>

EditUsers::EditUsers(QString& b, UserList* u, QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	baseUser = &b;
	users = u;

	UserEntry = new QLineEdit(this);
	UserEntry->setGeometry( 10, 10, 80, 25 );
	UserEntry->setMaxLength( 32767 );
	UserEntry->setEchoMode( QLineEdit::Normal );
	UserEntry->setFrame(true);

	UserListing = new QListBox(this);
	UserListing->setGeometry(110, 20, 100, 160);
	UserListing->setMouseTracking(true);

	addUser = new QPushButton(klocale->translate("Add"),this);
	addUser->setGeometry(10, 40, 80, 30);

	delUser = new QPushButton(klocale->translate("Delete"),this);
	delUser->setGeometry(10, 80, 80, 30);

	updUser = new QPushButton(klocale->translate("Update"),this);
	updUser->setGeometry(10, 120, 80, 30);

	Okay = new QPushButton(klocale->translate("Exit"),this);
	Okay->setGeometry(10, 160, 80, 30);

	addPublic = new QCheckBox(this);
	addPublic->setGeometry(220, 20, 140, 20);
	addPublic->setText(klocale->translate("Add Public"));

	delPublic = new QCheckBox(this);
	delPublic->setGeometry(220, 40, 140, 20);
	delPublic->setText(klocale->translate("Delete Public"));

	viewBusiness = new QCheckBox(this);
	viewBusiness->setGeometry(220, 60, 140, 20);
	viewBusiness->setText(klocale->translate("View Business"));

	addBusiness = new QCheckBox(this);
	addBusiness->setGeometry(220, 80, 140, 20);
	addBusiness->setText(klocale->translate("Add Business"));

	delBusiness = new QCheckBox(this);
	delBusiness->setGeometry(220, 100, 140, 20);
	delBusiness->setText(klocale->translate("Delete Business"));

	viewPersonnal = new QCheckBox(this);
	viewPersonnal->setGeometry(220, 120, 140, 20);
	viewPersonnal->setText(klocale->translate("View Personnal"));

	addPersonnal = new QCheckBox(this);
	addPersonnal->setGeometry(220, 140, 140, 20);
	addPersonnal->setText(klocale->translate("Add Personnal"));

	delPersonnal = new QCheckBox(this);
	delPersonnal->setGeometry(220, 160, 140, 20);
	delPersonnal->setText(klocale->translate("Delete Personnal"));

	resize(300,300);

	connect(addUser,SIGNAL(clicked()),SLOT(addNewUser()));
	connect(updUser,SIGNAL(clicked()),SLOT(updateUser()));
	connect(delUser,SIGNAL(clicked()),SLOT(deleteUser()));
	connect(Okay,SIGNAL(clicked()),SLOT(exit()));
	connect(UserListing,SIGNAL(highlighted(int)),SLOT(viewUser(int)));

	users->listUsers(*UserListing);
}

EditUsers::~EditUsers()
{
	delete UserEntry;
	delete UserListing;
	delete addUser;
	delete updUser;
	delete delUser;
	delete Okay;
	delete addPublic;
	delete delPublic;
	delete viewBusiness;
	delete addBusiness;
	delete delBusiness;
	delete viewPersonnal;
	delete addPersonnal;
	delete delPersonnal;
}

//
// signal emitted upon exit
//
void
EditUsers::exit()
{
	emit exitUsers();
}

//
// add a new user to the list
//
void
EditUsers::addNewUser()
{
	QString user = UserEntry->text();
	if(user == *baseUser)
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("Cannot add yourself to user list"));
	}
	else if(users->findUser(user) != (UserAccess*)0)
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("User already exists in user list"));
	}
	else if(user.isEmpty())
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("No username entered"));
	}
	else
	{
		UserAccess* ua = users->addUser(user);
		UserListing->insertItem(user);
		ua->setPublic(addPublic->isChecked(), delPublic->isChecked());
		ua->setBusiness(viewBusiness->isChecked(), addBusiness->isChecked(), delBusiness->isChecked());
		ua->setPersonnal(viewPersonnal->isChecked(), addPersonnal->isChecked(), delPersonnal->isChecked());
		UserEntry->setText("");
	}
}

//
// update an existing user record
//
void
EditUsers::updateUser()
{
	int item = UserListing->currentItem();
	if(item == -1)
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("Select a user to update"));
	}
	QString user = UserListing->text(item);
	UserAccess* ua = users->findUser(user);
	if(ua != (UserAccess*)0)
	{
		ua->setPublic(addPublic->isChecked(), delPublic->isChecked());
		ua->setBusiness(viewBusiness->isChecked(), addBusiness->isChecked(), delBusiness->isChecked());
		ua->setPersonnal(viewPersonnal->isChecked(), addPersonnal->isChecked(), delPersonnal->isChecked());
	}
}

//
// delete an existing user record
//
void
EditUsers::deleteUser()
{
	int item = UserListing->currentItem();
	if(item == -1)
	{
		QMessageBox::warning(this,PACKAGE,klocale->translate("Select a user to delete"));
	}
	QString user = UserListing->text(item);
	UserAccess* ua = users->findUser(user);
	if(ua != (UserAccess*)0)
	{
		users->removeUser(ua);
		UserListing->removeItem(item);
	}
}

//
// view the details for the selected user
//
void
EditUsers::viewUser(int item)
{
	QString user = UserListing->text(item);
	UserAccess* ua = users->findUser(user);
	if(ua != (UserAccess*)0)
	{
		addPublic->setChecked(ua->canAddPublic());
		delPublic->setChecked(ua->canDelPublic());
		viewBusiness->setChecked(ua->canViewBusiness());
		addBusiness->setChecked(ua->canAddBusiness());
		delBusiness->setChecked(ua->canDelBusiness());
		viewPersonnal->setChecked(ua->canViewPersonnal());
		addPersonnal->setChecked(ua->canAddPersonnal());
		delPersonnal->setChecked(ua->canDelPersonnal());
	}
}
