//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef EDITUSERS_INCLUDE
#define EDITUSERS_INCLUDE

#include <qwidget.h>
#include <qlistbox.h>
#include <qpushbt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qlist.h>
#include <qmsgbox.h>

#include "../config.h"

class UserList;
class UserAccess;

class EditUsers : public QWidget
{
	private:
	 Q_OBJECT

	private:
	 QLineEdit* UserEntry;
	 QListBox* UserListing;
	 QButton* addUser;
	 QButton* updUser;
	 QButton* delUser;
	 QButton* Okay;
	 QCheckBox* addPublic;
	 QCheckBox* delPublic;
	 QCheckBox* viewBusiness;
	 QCheckBox* addBusiness;
	 QCheckBox* delBusiness;
	 QCheckBox* viewPersonnal;
	 QCheckBox* addPersonnal;
	 QCheckBox* delPersonnal;

	 QString* baseUser;
	 UserList* users;

	public:
	 EditUsers(QString&, UserList*, QWidget* parent=0, const char* name=0);
	 ~EditUsers();

	protected:
	signals:
	 void exitUsers();

	public slots:
	 void addNewUser();
	 void updateUser();
	 void deleteUser();
	 void exit();
	 void viewUser(int);
};

#endif
