//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "Export.h"

Export::Export(char d, bool pub , bool bus , bool per, bool day)
{
	delim = d;
	setPublic(pub);
	setBusiness(bus);
	setPersonnal(per);
	setDayEvent(day);
}

Export::~Export()
{}

void
Export::setDelimiter(char d)
{
	delim = d;
}

char
Export::delimiter()
{
	return delim;
}

void
Export::setDateFormat(int d)
{
	df = d;
}

int
Export::dateFormat()
{
	return df;
}

bool
Export::exportPublic()
{
	return doPublic;
}

bool
Export::exportBusiness()
{
	return doBusiness;
}

bool
Export::exportPersonnal()
{
	return doPersonnal;
}

bool
Export::exportDayEvent()
{
	return doDayEvent;
}

void
Export::setPublic(bool pub)
{
	doPublic = pub;
}

void
Export::setBusiness(bool bus)
{
	doBusiness = bus;
}

void
Export::setPersonnal(bool per)
{
	doPersonnal = per;
}

void
Export::setDayEvent(bool day)
{
	doDayEvent = day;
}
