//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef _EXPORT_INCLUDE
#define _EXPORT_INCLUDE

#include <qstring.h>
#include <qdatetm.h>

class
Export
{
	private:
	 char delim;
	 int df;
	 bool doPublic;
	 bool doBusiness;
	 bool doPersonnal;
	 bool doDayEvent;

	public:
	 Export(char delim=',', bool pub=false, bool bus=false, bool per=false, bool day=false);
	 ~Export();
	 void setDelimiter(char);
	 char delimiter();
	 void setDateFormat(int);
	 int dateFormat();
	 void setPublic(bool);
	 void setBusiness(bool);
	 void setPersonnal(bool);
	 void setDayEvent(bool);
	 bool exportPublic();
	 bool exportBusiness();
	 bool exportPersonnal();
	 bool exportDayEvent();
};

#endif
