//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "ExportSelect.h"

#include <kapp.h>
#include <klocale.h>

ExportSelect::ExportSelect(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	Okay = new QPushButton(klocale->translate("Okay"),this);
	Okay->resize(40,30);
	Okay->setGeometry(240,240,60,30);

	cancel = new QPushButton(klocale->translate("Cancel"),this);
	cancel->resize(40,30);
	cancel->setGeometry(160,240,60,30);

	expPublic = new QCheckBox(this);
	expPublic->setGeometry(10, 20, 200, 20);
	expPublic->setText(klocale->translate("Export Public Appointments"));
	expPublic->setChecked(true);

	expBusiness = new QCheckBox(this);
	expBusiness->setGeometry(10, 50, 200, 20);
	expBusiness->setText(klocale->translate("Export Business Appointments"));
	expBusiness->setChecked(true);

	expPersonnal = new QCheckBox(this);
	expPersonnal->setGeometry(10, 80, 200, 20);
	expPersonnal->setText(klocale->translate("Export Personnal Appointments"));
	expPersonnal->setChecked(true);

	expDay = new QCheckBox(this);
	expDay->setGeometry(10, 110, 200, 20);
	expDay->setText(klocale->translate("Export Day Events"));
	expDay->setChecked(true);

	resize(300,300);

	connect(Okay,SIGNAL(clicked()),SLOT(exit()));
	connect(cancel,SIGNAL(clicked()),SLOT(quit()));
}

ExportSelect::~ExportSelect()
{
	delete Okay;
	delete cancel;
	delete expPublic;
	delete expBusiness;
	delete expPersonnal;
	delete expDay;
}

//
// signal emitted upon exit
//
void
ExportSelect::exit()
{
	emit exitExport();
}

void
ExportSelect::quit()
{
	emit quitExport();
}


bool
ExportSelect::exportPublic()
{
	return expPublic->isChecked();
}

bool
ExportSelect::exportBusiness()
{
	return expBusiness->isChecked();
}

bool
ExportSelect::exportPersonnal()
{
	return expPersonnal->isChecked();
}

bool
ExportSelect::exportDay()
{
	return expDay->isChecked();
}

