//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "FindText.h"

#include <kapp.h>
#include <klocale.h>

FindText::FindText(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	l1 = new QLabel(this);
	l1->setGeometry(10,10,70,20);
	l1->setText(klocale->translate("Find :"));
	l1->setAlignment(290);

	FindString = new QLineEdit(this);
	FindString->setGeometry( 90, 10, 100, 25 );
	FindString->setMaxLength( 32767 );
	FindString->setEchoMode( QLineEdit::Normal );
	FindString->setFrame(true);

	findApp = new QCheckBox(this);
	findApp->setGeometry(10, 70, 140, 20);
	findApp->setText(klocale->translate("Search Appointments"));
	findApp->setChecked(true);

	findEvent = new QCheckBox(this);
	findEvent->setGeometry(10, 90, 140, 20);
	findEvent->setText(klocale->translate("Search Day Events"));
	findEvent->setChecked(true);

	findNotes = new QCheckBox(this);
	findNotes->setGeometry(10, 110, 140, 20);
	findNotes->setText(klocale->translate("Search Day Notes"));
	findNotes->setChecked(true);

	Find = new QPushButton(klocale->translate("Find"),this);
	Find->setGeometry(240, 240, 60, 30);

	Cancel = new QPushButton(klocale->translate("Cancel"),this);
	Cancel->setGeometry(160, 240, 60, 30);

	resize(300,300);

	connect(Find,SIGNAL(clicked()),this,SLOT(find()));
	connect(Cancel,SIGNAL(clicked()),this,SLOT(exit()));
}

FindText::~FindText()
{
	delete l1;
	delete FindString;
	delete Find;
	delete Cancel;
	delete findApp;
	delete findEvent;
	delete findNotes;
}

//
// signal emitted upon exit
//
void
FindText::exit()
{
	emit exitFind();
}

//
// signal emitted upon exit
//
void
FindText::find()
{
	emit goFind();
}

QString&
FindText::searchString()
{
	localString = FindString->text();
	return localString;
}

bool
FindText::searchAppointments()
{
	return findApp->isChecked();
}

bool
FindText::searchDayEvents()
{
	return findEvent->isChecked();
}

bool
FindText::searchDayNotes()
{
	return findNotes->isChecked();
}

