/* This file is part of the KDE libraries

Copyright (C) 1997 Tim D. Gilman (tdgilman@best.org)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.

*/
#ifndef _KALDATETBL_H 
#define _KALDATETBL_H

/////////////////// KDateTable widget class //////////////////////
//
// Copyright (C) 1997 Tim D. Gilman
//
// Written using Qt (http://www.troll.no) for the
// KDE project (http://www.kde.org)
//
// This is a support class for the KDatePicker class.  It just
// draws the calender table without titles, but could theoretically
// be used as a standalone.
//
// When a date is selected by the user, it emits a signal: dateSelected(QDate)

//
// Mark W J Redding, I have used the kdatetbl class as a basis for my
// kalendar date picker....Shame they didn't make the data protected
// instead of private.
//

#include <qtablevw.h>
#include <qdatetm.h>


/**
* Draws a calendar table.
* @author Tim D. Gilman
* @version $Id: kdatetbl.h,v 1.3 1997/10/16 11:15:20 torben Exp $
*/
class KalDateTable: public QTableView
{
	private:
	 Q_OBJECT

	public:
	 KalDateTable(QWidget *parent=0, QDate date=QDate::currentDate(), const char *name=0, WFlags f=0);
	 ~KalDateTable();
	 void startOfWeek(int);

	public slots:
	 void goForward();
	 void goBackward();

	signals:
	 void monthChanged(QDate);
	 void dateSelected(QDate);

	protected:
	 void paintCell(QPainter*,int,int);
	 void resizeEvent(QResizeEvent*);
	 void mousePressEvent(QMouseEvent*);

	protected:
	 QDate m_date;
	 int m_firstDayOfWeek;
	 int m_daysInPrevMonth;
	 int m_oldRow;
	 int m_oldCol;
	 bool m_bSelection;
	 int m_selRow;
	 int m_selCol;
	 bool m_appoint[31];	// set to maximum number of days possible
	 bool m_note[31];
	 bool m_event[31];
	 bool m_holiday[31];
	 int m_startOfWeek;	// day to start the week

	 void setSelection(int,int);
	 void getPrevMonth(QDate,QDate&);
	 void getNextMonth(QDate,QDate&);
	 int dayNum(int,int);

	private:  // Disabled copy constructor and operator=
	 KalDateTable(const KalDateTable&) {}
	 KalDateTable &operator=(const KalDateTable&) { return *this; }

	public:
	 void setDate(int,int);
	 void setDayEvent(int,bool,bool,bool,bool);

};

#endif
