//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "Kconfigure.h"

#include "cfgDateFormat.h"
#include "cfgStartWeek.h"

//
// create a configuration widget
//
Kconfigure::Kconfigure(QWidget *parent, const char *name)
	: QDialog(parent,name)
{
	setCaption(klocale->translate("Configure"));

	l1 = new QLabel(this);
	l1->setText(klocale->translate("Full Name :"));
	l1->setGeometry(10,10,80,20);

	l2 = new QLabel(this);
	l2->setText(klocale->translate("E-Mail :"));
	l2->setGeometry(10,40,80,20);

	FullName = new QLineEdit(this);
	FullName->setGeometry(95,10,200,22);
	FullName->setMaxLength( 32767 );
	FullName->setEchoMode( QLineEdit::Normal );
	FullName->setFrame(true);

	EMail = new QLineEdit(this);
	EMail->setGeometry(95,40,200,22);
	EMail->setMaxLength( 32767 );
	EMail->setEchoMode( QLineEdit::Normal );
	EMail->setFrame(true);

	sizeMonth = new QCheckBox(this);
	sizeMonth->setGeometry(30,75,120,30);
	sizeMonth->setText(klocale->translate("Size Month to Fit"));

	sizeYear = new QCheckBox(this);
	sizeYear->setGeometry(160,75,120,30);
	sizeYear->setText(klocale->translate("Size Year to Fit"));

	g1 = new cfgDateFormat(this);
	g1->setGeometry(10,105,275,50);

//	g2 = new cfgStartWeek(this);
//	g2->setGeometry(10,135,275,70);

	cancel = new QPushButton(klocale->translate("Quit"),this);
	cancel->setGeometry(170,240,60,30);

	okay = new QPushButton(klocale->translate("Okay"),this);
	okay->setDefault(true);
	okay->setGeometry(240,240,60,30);

	resize(300,300);

	connect(okay,SIGNAL(clicked()),SLOT(exit()));
	connect(cancel,SIGNAL(clicked()),SLOT(quit()));

	connect(g1,SIGNAL(pressed(int)),SLOT(whichDateFormat(int)));
//	connect(g2,SIGNAL(pressed(int)),SLOT(whichStartWeek(int)));

	setDateFormat();
	setStartWeek();

	FullName->setFocus();
}

//
// tidy up
//
Kconfigure::~Kconfigure()
{
	delete l1;
	delete l2;
	delete FullName;
	delete EMail;
	delete g1;
//	delete g2;
	delete sizeMonth;
	delete sizeYear;
	delete cancel;
	delete okay;
}

//
// signal emitted when the okay button is pressed
//
void
Kconfigure::exit()
{
	emit exitConfig();
}

//
// signal emitted when the cancel button is pressed
//
void
Kconfigure::quit()
{
	emit quitConfig();
}

//
// set the date format
//
void
Kconfigure::whichDateFormat(int df)
{
	dateFormat = df;
}

//
// set the start of the week
//
void
Kconfigure::whichStartWeek(int sw)
{
	startWeek = sw;
}

//
// display the full name of the user
//
void
Kconfigure::setFullName(QString& nam)
{
	FullName->setText(nam.data());
}

//
// display the e-mail address of the user
//
void
Kconfigure::setEMail(QString& nam)
{
	EMail->setText(nam.data());
}

//
// display the user selected date format
//
void
Kconfigure::setDateFormat(int df)
{
	dateFormat = df;
	g1->setDateFormat(df);
}

//
// display the user selected start of week
//
void
Kconfigure::setStartWeek(int sw)
{
	startWeek = sw;
//	g2->setStartWeek(sw);
}

void
Kconfigure::setMonthSize(bool b)
{
	sizeMonth->setChecked(b);
}

void
Kconfigure::setYearSize(bool b)
{
	sizeYear->setChecked(b);
}

//
// return a pointer to the user entered full name
//
QString&
Kconfigure::getFullName()
{
	localName = FullName->text();
	return localName;
}

//
// return a pointer to the user entered e-mail address
//
QString&
Kconfigure::getEMail()
{
	localMail = EMail->text();
	return localMail;
}

//
// return the user selected date format
//
int
Kconfigure::getDateFormat()
{
	return dateFormat;
}


//
// return the user selected start of week
//
int
Kconfigure::getStartWeek()
{
	return startWeek;
}


bool
Kconfigure::getMonthSize()
{
	return sizeMonth->isChecked();
}

bool
Kconfigure::getYearSize()
{
	return sizeYear->isChecked();
}

