//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KCONFIGURE_INCLUDE
#define KCONFIGURE_INCLUDE

#include <qdialog.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qchkbox.h>

class cfgDateFormat;
class cfgStartWeek;

class
Kconfigure : public QDialog
{
	private:
	 Q_OBJECT
	 QLabel* l1;
	 QLabel* l2;
	 QLineEdit* FullName;
	 QLineEdit* EMail;
	 cfgDateFormat* g1;
	 cfgStartWeek* g2;
	 QCheckBox* sizeMonth;
	 QCheckBox* sizeYear;
	 QPushButton* cancel;
	 QPushButton* okay;

	 QString localName;
	 QString localMail;

	public:
	 Kconfigure(QWidget* parent=0, const char* name=0);
	 ~Kconfigure();

	 void setFullName(QString&);
	 void setEMail(QString&);
	 void setDateFormat(int df=0);
	 void setStartWeek(int sw=0);
	 void setMonthSize(bool b=false);
	 void setYearSize(bool b=false);

	 QString& getFullName();
	 QString& getEMail();
	 int getDateFormat();
	 int getStartWeek();
	 bool getMonthSize();
	 bool getYearSize();

	private:
	 int dateFormat;
	 int startWeek;

	protected:
	signals:
	 void exitConfig();
	 void quitConfig();

	public slots:
	 void exit();
	 void quit();
	 void whichDateFormat(int);
	 void whichStartWeek(int);
};

#endif
