//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KDAYVIEW_INCLUDE
#define KDAYVIEW_INCLUDE
//
//	The Kdayview class displays appointments for a selected day
//
#include <qwidget.h>
#include <qlist.h>
#include <qdatetm.h>

class TabularList;
class DayEvent;
class Appointment;

class
Kdayview : public QWidget
{
	private:
	 Q_OBJECT
	 TabularList* DayList;
	 TabularList* EventList;

	public:
	 Kdayview(QWidget* parent=0, const char* name=0);
	 void displayItem(Appointment*);
	 void displayItem(DayEvent*);
	 void clearItems();
	 int getSelectedTime();
	 void resize(int,int);
	 void setTop();
	 void clearEvents();
	 int getSelectedEvent();

	protected:
	signals:
	 void timePicked(int);
	 void eventPicked(int);

	public slots:
	 void pickTimeItem(int,int);
	 void pickEvent(int,int);
};

#endif
