//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KLOOK_INCLUDE
#define KLOOK_INCLUDE
//
//	The Klook class is the main application class
//
#include <qwidget.h>
#include <qdialog.h>
#include <qtabbar.h>
#include <qdstream.h>
#include <qtstream.h>
#include <qmsgbox.h>
#include <qlist.h>
#include <qdatetm.h>
#include <qmlined.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kstatusbar.h>
#include <kconfig.h>

#include "../config.h"

class DockWidget;
class KalDatePicker;
class ViewAppointment;
class EditAppointment;
class ViewTask;
class EditTask;
class Kdayview;
class Kweekview;
class Kmonthview;
class Kyearplan;
class Kconfigure;
class Ktodo;
class Calendar;
class Appointment;
class ToDo;
class Day;
class TaskList;
class UserList;
class EditUsers;
class UserAccess;
class DayEvent;
class EditEvent;
class FindText;
class Search;
class ExportSelect;

class
Klook : public KTopLevelWidget
{
	private:
	Q_OBJECT
	 QFrame* vmain;
	 QTabBar* views;
	 KalDatePicker* ThisMonth;
	 QLabel* selDate;
	 QLabel* selName;
	 QMultiLineEdit* dayNote;

	 KStatusBar* statusBar;
	 DockWidget* dock_widget;

	 KMenuBar* Menu;
	 QPopupMenu* file;
	 QPopupMenu* view;
	 QPopupMenu* appt;
	 QPopupMenu* task;
	 QPopupMenu* daye;
	 QPopupMenu* find;
	 QPopupMenu* help;
	 int fm_m,fm_o,fm_c,fm_s,fm_t,fm_x,fm_e;
	 int vm_d,vm_w,vm_m,vm_y,vm_t;
	 int am_n,am_e,am_v,am_d,at_n,at_e,at_v,at_d;
	 int tm_n,tm_e,tm_v,tm_d,tt_n,tt_e,tt_v,tt_d;
	 int de_n,de_e,de_d;
	 int fd_f,fd_a;

	 KToolBar* appToolBar;
	 KToolBar* doToolBar;
	 int appToolBarID,doToolBarID;

	 Kdayview* dayView;
	 Kweekview* weekView;
	 Kmonthview* monthView;
	 Kyearplan* yearPlan;
	 Ktodo* todoView;

	 EditAppointment* editApp;
	 ViewAppointment* viewApp;
	 EditTask* editTask;
	 ViewTask* viewTask;
	 EditEvent* editEvent;

	 Kconfigure* cfg;
	 EditUsers* usr;
	 FindText* finder;
	 ExportSelect* exp;

	 Calendar* cal;
	 TaskList* tasks;
	 UserList* users;

	 UserAccess* baseUser;
	 UserAccess* currUser;
	 UserAccess* nullUser;

	 QString* fullName;
	 QString* eMail;
	 QString* currFile;

	 Search* search;

	 int dateFormat;
	 int startWeek;
	 bool sizeMonthToFit;
	 bool sizeYearToFit;

	 bool allDone;
	 bool isOpen;
	 bool hasChanged;
	 bool readOnly;
	 int visibleView;

	public:
	 Klook(QWidget* parent=0, const char* name=0);
	 ~Klook();
	 Calendar& getCalendar();

	 enum {v_day,v_week,v_month,v_year,v_todo};

	private:
	 void load(QString&);
	 void save();
	 void disable();
	 void enable();
	 void openEditor(int);
	 void setupMenu();
	 void setupToolBar();
	 void setupStatusBar();
	 void disableAppointments();
	 void enableAppointments();
	 void disableTasks();
	 void enableTasks();
	 void displayName();
	 void enableMenus();
	 void disableMenus();
	 void disableViews();
	 void enableViews();
	 void selectView();
	 void selectView(int);
	 void showDayView();
	 void showWeekView();
	 void showMonthView();
	 void showYearPlan();
	 void showToDoView();
	 void loadPublic();
	 void LoadRC();
	 void SaveRC();

	public:
	 DockWidget& getDock();
	 int whatIsVisible();
	 void statusBarMessage(QString&);
	 void markAsUnchanged();

	protected:
	 void resizeEvent(QResizeEvent*);
	 void closeEvent(QCloseEvent*);
	 bool lockKalendar(bool me=false);
	 void unlockKalendar();
	 void selectDayNote();
	 void saveDayNote();
	 void doFind(bool);

	signals:
	 void quit();

	public slots:
	 void closeKalendar();
	 void configKalendar();
	 void tidyKalendar();
	 void exportKalendar();
	 void selectDay(int);
	 void selectDay(QDate);
	 void pickDayView();
	 void pickWeekView();
	 void pickMonthView();
	 void pickYearPlan();
	 void pickToDoView();
	 void viewDayItem();
	 void editDayItem(int);
	 void editWeekItem(int,int);
	 void editDayItem();
	 void deleteDayItem();
	 void newDayItem();
	 void doneDayEdit(Appointment*);
	 void abortDayEdit(Appointment*);
	 void doneDayEdit(bool);
	 void doneDayView();
	 void doneTaskEdit();
	 void doneTaskView();
	 void abortTaskEdit(ToDo*);
	 void editTaskItem(int);
	 void editTaskItem();
	 void newTaskItem();
	 void viewTaskItem();
	 void deleteTaskItem();
	 void finishTaskItem(int);
	 void storeConfig();
	 void abortConfig();
	 void helpAbout();
	 void helpHelp();
	 void secureKalendar();
	 void doneUsers();
	 void openMyKalendar();
	 void openKalendar();
	 void markAsChanged();
	 void selectDayView(int);
	 void selectDayView(int,int);
	 void newDayEvent();
	 void editDayEvent();
	 void editDayEvent(int);
	 void doneDayEvent(DayEvent*);
	 void doneDayEvent(bool);
	 void abortDayEvent(DayEvent*);
	 void deleteDayEvent();
	 void refreshMonth(int,int);
	 void beginFind();
	 void abortFind();
	 void Finder();
	 void findAgain();
	 void doExport();
	 void abortExport();

	private:
	 static const int version = 13;

};

#endif
