//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "Kmonthview.h"

#include "MonthTable.h"
#include "Appointment.h"
#include "DayEvent.h"

//
// create a table capable of displaying information for a single month
//
Kmonthview::Kmonthview(bool fit, QWidget *parent, const char *name) 
	: QWidget(parent,name)
{
	MonthList = new MonthTable(fit,this);
	MonthList->setGeometry(0,0,240,220);

	setDays(0,0);

	connect(MonthList,SIGNAL(dayPicked(int)),SLOT(viewCurrentDay(int)));

	MonthList->setFocus();
}

//
// ensure that this widget fills the available screen space
//
void
Kmonthview::resize(int w , int h)
{
	MonthList->setGeometry(0,0,w,h);
	MonthList->resize(w,h);
}

//
// place an appointment on the list in the correct day
//
void
Kmonthview::displayItem(int day, Appointment* a)
{
	MonthList->setDayEvent(day,a->getSubject(),false);
}

//
// place an day event on the list in the correct day
//
void
Kmonthview::displayItem(int day, DayEvent* e)
{
	MonthList->setDayEvent(day,e->getSubject(),true);
}

//
// remove all appointment from the list
//
void
Kmonthview::clearItems()
{
	MonthList->clearMonth();
	MonthList->update();
}

//
// signal emitted to inform anyone of a change to the number of days in the month
//
void
Kmonthview::setDays(int d, int s)
{
	if(s == 7)
	{
		s = 0;	//make sunday first of week
	}
	emit daysInMonth(d,s);
}

//
// signal emitted to inform anyone of a change to the currently selected date
//
void
Kmonthview::setCurrentDay(int d)
{
	emit changeDay(d);
}

//
// emit a signal to notify of a new date
//
void
Kmonthview::viewCurrentDay(int d)
{
	emit viewDay(d);
}

void
Kmonthview::setFit(bool b)
{
	MonthList->setFit(b);
}

