//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KMONTHVIEW_INCLUDE
#define KMONTHVIEW_INCLUDE
//
//	The Kmonthview class displays appointments for a selected month
//
#include <qwidget.h>
#include <qlist.h>
#include <qpainter.h>

class MonthTable;
class Appointment;
class DayEvent;

class
Kmonthview : public QWidget
{
	private:
	 Q_OBJECT
	 MonthTable* MonthList;

	public:
	 Kmonthview(bool fit=false, QWidget* parent=0, const char* name=0);
	 void displayItem(int,Appointment*);
	 void displayItem(int,DayEvent*);
	 void clearItems();
	 void resize(int,int);
	 void setDays(int,int);
	 void setFit(bool f=false);

	protected:
	signals:
	 void daysInMonth(int,int);
	 void changeDay(int);
	 void viewDay(int);

	public slots:
	 void setCurrentDay(int);
	 void viewCurrentDay(int);

};

#endif
