//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "Ktodo.h"

#include "ToDo.h"
#include "TabularList.h"

Ktodo::Ktodo(QWidget *parent, const char *name) 
	: QWidget(parent,name)
{
	ToDoList = new TabularList(this, "ToDoList",3);
	ToDoList->setGeometry(0,0,240,220);

	ToDoList->setNumCols(4);
	ToDoList->setColumn(0,klocale->translate("Pri"),50);
	ToDoList->setColumn(1,"Com",30,KTabListBox::PixmapColumn);
	ToDoList->setColumn(2,"Sen",30,KTabListBox::PixmapColumn);
	ToDoList->setColumn(3,klocale->translate("Task"),170);
	ToDoList->setSeparator('\t');

	ToDoList->setAutoUpdate(true);

	connect(ToDoList,SIGNAL(selected(int,int)),SLOT(picked(int,int)));
}

void
Ktodo::resize(int w , int h)
{
	ToDoList->setGeometry(0,0,w,h);
	ToDoList->setColumnWidth(3,w - 50 - 20);
}

void
Ktodo::clear()
{
	ToDoList->clear();
	ToDoList->repaint();
}

void
Ktodo::showTask(ToDo* t)
{
	QString done(" ");
	QString sense("B");
	if(t->isComplete())
	{
		done = "Y";
	}
	if(t->getSensitivity() == ToDo::personal)
	{
		sense="P";
	}
	else if(t->getSensitivity() == ToDo::academic)
	{
		sense="S";
	}

	QString p;

	switch(t->getPriority())
	{
	case ToDo::high   : p = klocale->translate("High");	break;
	case ToDo::medium : p = klocale->translate("Medium");	break;
	default           : p = klocale->translate("Low");	break;
	}
	QString s = p + "\t" + done + "\t" + sense + "\t" + t->getSubject();

	ToDoList->insertItem(s);

	ToDoList->changeItemColor(black);
	QDate curr = QDate::currentDate();
	QDate task = t->getStartDate();
	if(curr >= task)
	{
		ToDoList->changeItemColor(green);
	}
	task = task.addDays(t->getDuration());
	if(curr >= task)
	{
		ToDoList->changeItemColor(red);
	}
	if(t->isComplete())
	{
		ToDoList->changeItemColor(blue);
	}
}

void
Ktodo::picked(int ind , int col)
{
	switch(col)
	{
	case 1:	emit taskDone(ind);	break;
	case 2:
	case 3:	emit taskPicked(ind);	break;
	}
}

int
Ktodo::currentTask()
{
	return ToDoList->currentItem();
}

void
Ktodo::SelectTask(int ind)
{
	ToDoList->setCurrentItem(ind);
	ToDoList->markItem(ind);
	ToDoList->repaint();
}

