//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KTODO_INCLUDE
#define KTODO_INCLUDE
//
//	The Ktodo class displays the current todo list
//
#include <qwidget.h>

#include <ktablistbox.h>

class ToDo;
class TabularList;

class
Ktodo : public QWidget
{
	private:
	 Q_OBJECT
	 TabularList* ToDoList;

	public:
	 Ktodo(QWidget* parent=0, const char* name=0);
	 void clear();
	 void showTask(ToDo*);
	 int currentTask();
	 void resize(int,int);
	 void SelectTask(int ind=0);

	protected:
	signals:
	 void taskPicked(int);
	 void taskDone(int);

	public slots:
	 void picked(int,int);
};

#endif
