//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <kapp.h>
#include <klocale.h>

#include "Kweekview.h"
#include "Appointment.h"
#include "TimeSlots.h"

//
// create a weekly viewer
//
Kweekview::Kweekview(QWidget *parent, const char *name) 
	: QWidget(parent,name)
{
	WeekList = new KTabListBox(this, "WeekList", 8);
	WeekList->setGeometry(0,0,240,220);

	WeekList->setNumCols(8);
	WeekList->setColumn(0,klocale->translate("Time"),40);
	WeekList->setColumn(1,klocale->translate("Sun"),20);
	WeekList->setColumn(2,klocale->translate("Mon"),20);
	WeekList->setColumn(3,klocale->translate("Tue"),20);
	WeekList->setColumn(4,klocale->translate("Wed"),20);
	WeekList->setColumn(5,klocale->translate("Thu"),20);
	WeekList->setColumn(6,klocale->translate("Fri"),20);
	WeekList->setColumn(7,klocale->translate("Sat"),20);
	WeekList->setSeparator('\t');

TimeSlots ts;

	for(int i = 0; i < TimeSlots::totalSlots; i++)
	{
		WeekList->insertItem(ts.whichTime(i));
	}

	connect(WeekList,SIGNAL(selected(int,int)),SLOT(pickTimeItem(int,int)));

	WeekList->setFocus();
}

//
// ensure that on a resize, this widget full the available screen space
//
void
Kweekview::resize(int w , int h)
{
int tw;

	WeekList->setAutoUpdate(false);
	WeekList->setGeometry(0,0,w,h);
	tw = (w - 40 - 20) / 7;
	for(int i = 1; i < 8; i++)
	{
		WeekList->setColumnWidth(i,tw);
	}
	WeekList->setAutoUpdate(true);
	WeekList->update();
}

//
// signal emitted when a date/time combination is pressed
// this signal is not emitted if the column containing the times is pressed
//
void
Kweekview::pickTimeItem(int ind , int col )
{
	if(col > 0)
	{
		emit timePicked(col - 1,ind);
	}
}

//
// display a string of text in the correct column, and for the date range specified
//
void
Kweekview::displayItem(int col, Appointment* a)
{
	WeekList->setAutoUpdate(false);
	WeekList->changeItemPart(a->getSubject(),a->getStartTime(),col);
	for(int i = a->getStartTime() + 1; i <= a->getFinishTime(); i++)
	{
		WeekList->changeItemPart(" ...",i,col);
	}
	WeekList->setAutoUpdate(true);
	WeekList->update();
}

//
// clear the weekly view of appointments
//
void
Kweekview::clearItems()
{
	WeekList->setAutoUpdate(false);
	for(int i = 0; i < TimeSlots::totalSlots; i++)
	{
		for(int j = 1; j < 8; j++)
		{
			WeekList->changeItemPart(" ",i,j);
		}
	}
	WeekList->setAutoUpdate(true);
	WeekList->update();
}

//
// set the column titles based upon the day of the week specified
//
void
Kweekview::baseDay(int day)
{
int c,w;

	w = WeekList->cellWidth(1);

	for(int i = day; i < day + 7; i++)
	{
		c = i - day + 1;
		switch(i)
		{
		case  1:
		case  8:
			WeekList->setColumn(c,klocale->translate("Mon"),w);
			break;
		case  2:
		case  9:
			WeekList->setColumn(c,klocale->translate("Tue"),w);
			break;
		case  3:
		case 10:
			WeekList->setColumn(c,klocale->translate("Wed"),w);
			break;
		case  4:
		case 11:
			WeekList->setColumn(c,klocale->translate("Thu"),w);
			break;
		case  5:
		case 12:
			WeekList->setColumn(c,klocale->translate("Fri"),w);
			break;
		case  6:
		case 13:
			WeekList->setColumn(c,klocale->translate("Sat"),w);
			break;
		case  7:
		case 14:
			WeekList->setColumn(c,klocale->translate("Sun"),w);
			break;
		}
	}
}

//
// set the top item visible
//
void
Kweekview::setTop()
{
QTime now = QTime::currentTime();

	int idx = (now.hour() * TimeSlots::hourUnits) + (now.minute() / TimeSlots::minuteUnits);
	WeekList->setTopItem(idx);
}

