//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KWEEKVIEW_INCLUDE
#define KWEEKVIEW_INCLUDE
//
//	The Kweekview class displays appointments for a selected week
//
#include <qwidget.h>
#include <qlist.h>
#include <qpainter.h>
#include <qdatetm.h>

#include <ktablistbox.h>

class Appointment;

class
Kweekview : public QWidget
{
	private:
	 Q_OBJECT
	 KTabListBox* WeekList;

	public:
	 Kweekview(QWidget* parent=0, const char* name=0);
	 void displayItem(int,Appointment*);
	 void clearItems();
	 void resize(int,int);
	 void baseDay(int);
	 void setTop();
	protected:
	signals:
	 void timePicked(int,int);
	public slots:
	 void pickTimeItem(int,int);
};

#endif
