//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "Kyearplan.h"

#include "YearTable.h"
#include "Appointment.h"
#include "DayEvent.h"

//
// create a table capable of displaying information for a single Year
//
Kyearplan::Kyearplan(bool fit, QWidget *parent, const char *name) 
	: QWidget(parent,name)
{
	YearList = new YearTable(fit,this);
	YearList->setGeometry(0,0,240,220);

	connect(YearList,SIGNAL(dayPicked(int,int)),SLOT(viewCurrentDay(int,int)));

	YearList->setFocus();
}

//
// ensure that this widget fills the available screen space
//
void
Kyearplan::resize(int w , int h)
{
	YearList->setGeometry(0,0,w,h);
	YearList->resize(w,h);
}

void
Kyearplan::setYear(int y)
{
	YearList->setYear(y);
}

//
// remove all appointment from the list
//
void
Kyearplan::clearItems()
{
	YearList->clearYear();
	YearList->update();
}

//
// signal emitted to inform anyone of a change to the currently selected date
//
void
Kyearplan::setCurrentDay(int m,int d)
{
	emit changeDay(m,d);
}

//
// emit a signal to notify of a new date
//
void
Kyearplan::viewCurrentDay(int m,int d)
{
	emit viewDay(m,d);
}

void
Kyearplan::displayDay(int m, int d, int a, bool n, int e, bool h)
{
	YearList->setDayEvent(m,d,a,n,e,h);
}

void
Kyearplan::addAppointment(int m , int d)
{
	YearList->addToDay(m,d,1);
}

void
Kyearplan::addDayEvent(int m , int d , bool h)
{
	YearList->addToDay(m,d,0,1,h);
}

void
Kyearplan::setFit(bool b)
{
	YearList->setFit(b);
}

