//
// Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef KYEARPLAN_INCLUDE
#define KYEARPLAN_INCLUDE
//
//	The Kyearplan class displays appointments for a selected year
//
#include <qwidget.h>
#include <qlist.h>
#include <qpainter.h>

class YearTable;
class Appointment;
class DayEvent;

class
Kyearplan : public QWidget
{
	private:
	 Q_OBJECT
	 YearTable* YearList;

	public:
	 Kyearplan(bool fit=false, QWidget* parent=0, const char* name=0);
	 void clearItems();
	 void resize(int,int);
	 void displayDay(int,int,int,bool,int,bool);
	 void setYear(int);
	 void addAppointment(int,int);
	 void addDayEvent(int,int,bool h=false);
	 void setFit(bool f=false);

	protected:
	signals:
	 void changeDay(int,int);
	 void viewDay(int,int);

	public slots:
	 void setCurrentDay(int,int);
	 void viewCurrentDay(int,int);

};

#endif
